/**
 * Gestionnaire de l'interface utilisateur (modales, toasts, etc.)
 */

const UIManager = {
    /**
     * Affiche la modale d'aperçu d'image
     */
    showImagePreview(imageUrl, title) {
        const modal = document.getElementById('imagePreviewModal');
        const previewImage = document.getElementById('previewImage');
        const previewTitle = document.getElementById('previewTitle');
        
        if (modal && previewImage && previewTitle) {
            previewImage.src = imageUrl;
            previewTitle.textContent = title;
            modal.classList.add('show');
            
            // Empêcher le scroll du body
            document.body.style.overflow = 'hidden';
        }
    },
    
    /**
     * Ferme la modale d'aperçu
     */
    closeImagePreview(event) {
        // Ne fermer que si on clique sur le fond noir ou le bouton X
        if (!event || event.target.id === 'imagePreviewModal' || event.target.classList.contains('image-preview-close')) {
            const modal = document.getElementById('imagePreviewModal');
            if (modal) {
                modal.classList.remove('show');
                
                // Réactiver le scroll du body
                document.body.style.overflow = '';
            }
        }
    },
    
    /**
     * Affiche un toast
     */
    showToast(message) {
        Utils.showToast(message);
    },
    
    /**
     * Affiche/masque le loader global
     */
    showLoader(show = true) {
        let loader = document.getElementById('globalLoader');
        
        if (!loader) {
            loader = document.createElement('div');
            loader.id = 'globalLoader';
            loader.className = 'global-loader';
            loader.innerHTML = `
                <div class="loader-content">
                    <div class="loader-spinner"></div>
                    <p class="loader-text">Chargement...</p>
                </div>
            `;
            document.body.appendChild(loader);
        }
        
        if (show) {
            loader.style.display = 'flex';
        } else {
            loader.style.display = 'none';
        }
    },
    
    /**
     * Confirme une action
     */
    async confirm(message) {
        return confirm(message);
    },
    
    /**
     * Alerte
     */
    alert(message) {
        alert(message);
    },
    
    /**
     * Smooth scroll vers un élément
     */
    scrollToElement(elementId) {
        const element = document.getElementById(elementId);
        if (element) {
            element.scrollIntoView({ 
                behavior: 'smooth', 
                block: 'start' 
            });
        }
    }
};
