/**
 * CONFIGURATION DES TAUX ET PRIX
 * Modifiez ce fichier pour ajuster les prix et délais de livraison
 */

const RATES = {
    
    // =================================================================
    // MODES DE LIVRAISON
    // =================================================================
    
    // Multiplicateurs de prix selon le mode de livraison
    // 1.0 = prix de base, 1.25 = +25%, 1.50 = +50%
    DELIVERY_MULTIPLIERS: {
        'economique': 1.0,
        'standard': 1.25,
        'urgent': 1.50
    },
    
    // Labels et délais affichés
    DELIVERY_LABELS: {
        'economique': { 
            name: 'Économique', 
            time: '5-7 jours ouvrés', 
            badge: 'Inclus' 
        },
        'standard': { 
            name: 'Standard', 
            time: '3-4 jours ouvrés', 
            badge: '+25%' 
        },
        'urgent': { 
            name: 'Urgent', 
            time: '24-48h', 
            badge: '+50%' 
        }
    },
    
    // =================================================================
    // PRIX DES FORMATS (en euros TTC)
    // =================================================================
    
    FORMATS: {
        'A6': { 
            label: 'A6', 
            dim: '10×15cm', 
            prix: 4.90 
        },
        'A5': { 
            label: 'A5', 
            dim: '15×21cm', 
            prix: 9.90 
        },
        'A4': { 
            label: 'A4', 
            dim: '21×30cm', 
            prix: 19.90 
        },
        'A3': { 
            label: 'A3', 
            dim: '30×42cm', 
            prix: 29.90 
        },
        'A2': { 
            label: 'A2', 
            dim: '42×59cm', 
            prix: 39.90 
        },
        'A1': { 
            label: 'A1', 
            dim: '59×84cm', 
            prix: 59.90 
        }
    },
    
    // =================================================================
    // TVA
    // =================================================================
    
    TVA_RATE: 0.20  // 20% de TVA
};

// Appliquer les taux à la config principale au chargement
document.addEventListener('DOMContentLoaded', function() {
    if (typeof CONFIG !== 'undefined') {
        CONFIG.DELIVERY_MULTIPLIERS = RATES.DELIVERY_MULTIPLIERS;
        CONFIG.DELIVERY_LABELS = RATES.DELIVERY_LABELS;
        CONFIG.FORMATS = RATES.FORMATS;
        CONFIG.TVA_RATE = RATES.TVA_RATE;
        console.log('✅ Taux chargés depuis config-rates.js');
    }
});
