<?php
/**
 * API E-COMMERCE - AFFICHES PERSONNALISÉES
 * Récupère les catégories, styles et produits depuis PostgreSQL
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Configuration BDD
define('DB_HOST', 'oz9643-001.eu.clouddb.ovh.net');
define('DB_PORT', '35297');
define('DB_USER', 'user_recreatoon');
define('DB_PASS', 'MathelodIMG59');  // <-- REMPLACEZ PAR VOTRE MOT DE PASSE
define('DB_NAME', 'recreatoon_DDB');

// Connexion PDO
function getDB() {
    static $pdo = null;
    if ($pdo === null) {
        try {
            $dsn = sprintf("pgsql:host=%s;port=%s;dbname=%s", DB_HOST, DB_PORT, DB_NAME);
            $pdo = new PDO($dsn, DB_USER, DB_PASS, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false
            ]);
        } catch(PDOException $e) {
            http_response_code(500);
            die(json_encode(['error' => 'Connexion base de données échouée']));
        }
    }
    return $pdo;
}

// Router
$action = $_GET['action'] ?? 'categories';

try {
    $pdo = getDB();
    
    switch($action) {
        
        // GET /api.php?action=categories
        // Récupère toutes les catégories actives avec leur nombre de styles
        case 'categories':
            $stmt = $pdo->query("
                SELECT 
                    c.slug,
                    c.nom,
                    c.description,
                    c.url_img_categorie,
                    c.ordre,
                    COUNT(s.style_id) as nb_styles
                FROM categories c
                LEFT JOIN styles s ON c.slug = s.categorie_slug AND s.actif = TRUE
                WHERE c.actif = TRUE
                GROUP BY c.slug, c.nom, c.description, c.url_img_categorie, c.ordre
                ORDER BY c.ordre ASC
            ");
            
            $categories = $stmt->fetchAll();
            
            echo json_encode([
                'success' => true,
                'data' => $categories,
                'total' => count($categories)
            ]);
            break;
        
        // GET /api.php?action=styles&categorie=affiche-couple
        // Récupère les styles d'une catégorie spécifique
        case 'styles':
            $categorie = $_GET['categorie'] ?? '';
            
            if (empty($categorie)) {
                // Tous les styles actifs des catégories actives uniquement
                $stmt = $pdo->query("
                    SELECT 
                        s.style_id,
                        s.titre,
                        s.theme,
                        s.categorie_slug,
                        s.categorie_nom,
                        s.descriptif,
                        s.prompt,
                        s.url,
                        s.url2,
                        s.ordre,
                        s.background,
                        s.flag_champ_scene,
                        s.actif
                    FROM styles s
                    INNER JOIN categories c ON s.categorie_slug = c.slug
                    WHERE s.actif = TRUE AND c.actif = TRUE
                    ORDER BY s.ordre ASC, s.titre ASC
                ");
            } else {
                // Styles d'une catégorie (vérifier que la catégorie est active)
                $stmt = $pdo->prepare("
                    SELECT 
                        s.style_id,
                        s.titre,
                        s.theme,
                        s.categorie_slug,
                        s.categorie_nom,
                        s.descriptif,
                        s.prompt,
                        s.url,
                        s.url2,
                        s.ordre,
                        s.background,
                        s.flag_champ_scene,
                        s.actif
                    FROM styles s
                    INNER JOIN categories c ON s.categorie_slug = c.slug
                    WHERE s.categorie_slug = ? AND s.actif = TRUE AND c.actif = TRUE
                    ORDER BY s.ordre ASC, s.titre ASC
                ");
                $stmt->execute([$categorie]);
            }
            
            $styles = $stmt->fetchAll();
            
            echo json_encode([
                'success' => true,
                'data' => $styles,
                'total' => count($styles),
                'categorie' => $categorie
            ]);
            break;
        
        // GET /api.php?action=style&id=51
        // Récupère un style spécifique par son ID
        case 'style':
            $id = $_GET['id'] ?? 0;
            
            if (empty($id)) {
                throw new Exception('ID manquant');
            }
            
            $stmt = $pdo->prepare("
                SELECT 
                    s.style_id,
                    s.titre,
                    s.theme,
                    s.categorie_slug,
                    s.categorie_nom,
                    s.descriptif,
                    s.prompt,
                    s.url,
                    s.url2,
                    s.ordre,
                    s.background,
                    s.flag_champ_scene,
                    s.actif,
                    c.description as categorie_description
                FROM styles s
                LEFT JOIN categories c ON s.categorie_slug = c.slug
                WHERE s.style_id = ? AND s.actif = TRUE
            ");
            $stmt->execute([$id]);
            
            $style = $stmt->fetch();
            
            if (!$style) {
                throw new Exception('Style non trouvé');
            }
            
            echo json_encode([
                'success' => true,
                'data' => $style
            ]);
            break;
        
        // GET /api.php?action=search&q=cartoon
        // Recherche dans les titres et descriptions
        case 'search':
        case 'search_styles':
            $query = $_GET['q'] ?? '';
            
            if (empty($query)) {
                throw new Exception('Recherche vide');
            }
            
            $stmt = $pdo->prepare("
                SELECT 
                    s.style_id,
                    s.titre,
                    s.theme,
                    s.categorie_slug,
                    s.categorie_nom,
                    s.descriptif,
                    s.url,
                    s.url2,
                    s.ordre,
                    s.background,
                    s.flag_champ_scene
                FROM styles s
                INNER JOIN categories c ON s.categorie_slug = c.slug
                WHERE s.actif = TRUE 
                  AND c.actif = TRUE
                  AND (
                    LOWER(s.titre) LIKE LOWER(?) 
                    OR LOWER(s.descriptif) LIKE LOWER(?)
                    OR LOWER(s.categorie_nom) LIKE LOWER(?)
                  )
                ORDER BY s.titre ASC
                LIMIT 50
            ");
            
            $search = "%{$query}%";
            $stmt->execute([$search, $search, $search]);
            
            $results = $stmt->fetchAll();
            
            echo json_encode([
                'success' => true,
                'data' => $results,
                'total' => count($results),
                'query' => $query
            ]);
            break;
        
        // GET /api.php?action=stats
        // Statistiques globales
        case 'stats':
            $stats = [];
            
            // Total styles actifs
            $stmt = $pdo->query("SELECT COUNT(*) as total FROM styles WHERE actif = TRUE");
            $stats['total_styles'] = $stmt->fetch()['total'];
            
            // Total catégories actives
            $stmt = $pdo->query("SELECT COUNT(*) as total FROM categories WHERE actif = TRUE");
            $stats['total_categories'] = $stmt->fetch()['total'];
            
            // Styles par catégorie
            $stmt = $pdo->query("
                SELECT categorie_nom, COUNT(*) as nb
                FROM styles
                WHERE actif = TRUE
                GROUP BY categorie_nom
                ORDER BY nb DESC
            ");
            $stats['by_category'] = $stmt->fetchAll();
            
            echo json_encode([
                'success' => true,
                'data' => $stats
            ]);
            break;
        
        // POST /api.php?action=submit_order
        // Enregistre une nouvelle commande
        case 'submit_order':
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                throw new Exception('Méthode POST requise');
            }
            
            // Récupérer les données
            $payment_id = $_POST['payment_id'] ?? null;
            
            // Si payment_id est vide ou "undefined", en générer un unique
            if (empty($payment_id) || $payment_id === 'undefined' || $payment_id === 'null') {
                $payment_id = 'CC-' . date('YmdHis') . '-' . strtoupper(substr(uniqid(), -6));
            }
            
            $payment_method = $_POST['payment_method'] ?? 'stripe';
            $payment_status = $_POST['payment_status'] ?? 'pending';
            $order_type = $_POST['order_type'] ?? 'cart';
            
            // Totaux
            $total_items = intval($_POST['total_items'] ?? 0);
            $total_quantity = intval($_POST['total_quantity'] ?? 0);
            $total_price = floatval($_POST['total_price'] ?? 0);
            
            // Utilisateur (optionnel)
            $user_id = !empty($_POST['user_id']) ? intval($_POST['user_id']) : null;
            $user_email = $_POST['user_email'] ?? null;
            $user_authenticated = ($_POST['user_authenticated'] ?? 'false') === 'true';
            
            // Démarrer une transaction
            $pdo->beginTransaction();
            
            try {
                // Insérer la commande dans la table "commande"
                $stmt = $pdo->prepare("
                    INSERT INTO commande (
                        payment_id, user_id, user_email, user_authenticated,
                        payment_method, payment_status, order_type,
                        total_items, total_quantity, total_price
                    ) VALUES (
                        ?, ?, ?, ?,
                        ?, ?, ?,
                        ?, ?, ?
                    ) RETURNING id
                ");
                
                $stmt->execute([
                    $payment_id, $user_id, $user_email, $user_authenticated,
                    $payment_method, $payment_status, $order_type,
                    $total_items, $total_quantity, $total_price
                ]);
                
                $commande_id = $stmt->fetch()['id'];
                
                // Insérer les lignes de commande dans "cmdeproduit"
                // Chaque ligne = une combinaison image + format + quantité
                $stmtLigne = $pdo->prepare("
                    INSERT INTO cmdeproduit (
                        commande_id, item_id, style, format,
                        quantity, delivery, price, image_url,
                        chemin_pdf, chemin_vignette
                    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                ");
                
                for ($i = 0; $i < $total_items; $i++) {
                    $item_id = $_POST["item_{$i}_id"] ?? '';
                    $item_style = $_POST["item_{$i}_style"] ?? '';
                    $item_format = $_POST["item_{$i}_format"] ?? '';
                    $item_quantity = intval($_POST["item_{$i}_quantity"] ?? 1);
                    $item_delivery = $_POST["item_{$i}_delivery"] ?? 'economique';
                    $item_price = floatval($_POST["item_{$i}_price"] ?? 0);
                    $item_image = $_POST["item_{$i}_image"] ?? '';
                    
                    // Les chemins PDF et vignette seront générés plus tard par le workflow de production
                    $chemin_pdf = null;
                    $chemin_vignette = $item_image; // La vignette est l'image générée
                    
                    if (!empty($item_style) && !empty($item_format)) {
                        $stmtLigne->execute([
                            $commande_id,
                            $item_id,
                            $item_style,
                            $item_format,
                            $item_quantity,
                            $item_delivery,
                            $item_price,
                            $item_image,
                            $chemin_pdf,
                            $chemin_vignette
                        ]);
                    }
                }
                
                // Valider la transaction
                $pdo->commit();
                
                echo json_encode([
                    'success' => true,
                    'message' => 'Commande enregistrée',
                    'data' => [
                        'commande_id' => $commande_id,
                        'payment_id' => $payment_id,
                        'total' => $total_price
                    ]
                ]);
                
            } catch (Exception $e) {
                $pdo->rollBack();
                throw new Exception('Erreur lors de l\'enregistrement: ' . $e->getMessage());
            }
            break;
        
        // GET /api.php?action=orders&user_id=xxx ou &email=xxx
        // Récupère les commandes d'un client
        case 'orders':
            $email = $_GET['email'] ?? '';
            $user_id = $_GET['user_id'] ?? '';
            
            if (empty($email) && empty($user_id)) {
                throw new Exception('Email ou user_id requis');
            }
            
            if (!empty($user_id)) {
                $stmt = $pdo->prepare("
                    SELECT * FROM commande 
                    WHERE user_id = ? 
                    ORDER BY created_at DESC
                ");
                $stmt->execute([$user_id]);
            } else {
                $stmt = $pdo->prepare("
                    SELECT * FROM commande 
                    WHERE user_email = ? 
                    ORDER BY created_at DESC
                ");
                $stmt->execute([$email]);
            }
            
            $commandes = $stmt->fetchAll();
            
            // Récupérer les produits pour chaque commande
            foreach ($commandes as &$commande) {
                $stmtProduits = $pdo->prepare("
                    SELECT * FROM cmdeproduit 
                    WHERE commande_id = ?
                ");
                $stmtProduits->execute([$commande['id']]);
                $commande['produits'] = $stmtProduits->fetchAll();
            }
            
            echo json_encode([
                'success' => true,
                'data' => $commandes,
                'total' => count($commandes)
            ]);
            break;
        
        // GET /api.php?action=order&id=xxx
        // Récupère une commande spécifique
        case 'order':
            $id = $_GET['id'] ?? '';
            
            if (empty($id)) {
                throw new Exception('ID requis');
            }
            
            $stmt = $pdo->prepare("SELECT * FROM commande WHERE id = ?");
            $stmt->execute([$id]);
            
            $commande = $stmt->fetch();
            
            if (!$commande) {
                throw new Exception('Commande non trouvée');
            }
            
            // Récupérer les produits
            $stmtProduits = $pdo->prepare("SELECT * FROM cmdeproduit WHERE commande_id = ?");
            $stmtProduits->execute([$commande['id']]);
            $commande['produits'] = $stmtProduits->fetchAll();
            
            echo json_encode([
                'success' => true,
                'data' => $commande
            ]);
            break;
        
        // POST /api.php?action=update_pdf
        // Met à jour le chemin_pdf d'un produit de commande
        case 'update_pdf':
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                throw new Exception('Méthode POST requise');
            }
            
            $produit_id = $_POST['produit_id'] ?? $_GET['produit_id'] ?? '';
            $chemin_pdf = $_POST['chemin_pdf'] ?? $_GET['chemin_pdf'] ?? '';
            
            if (empty($produit_id)) {
                throw new Exception('produit_id requis');
            }
            
            if (empty($chemin_pdf)) {
                throw new Exception('chemin_pdf requis');
            }
            
            $stmt = $pdo->prepare("
                UPDATE cmdeproduit 
                SET chemin_pdf = ?, 
                    statut = 'PDF'
                WHERE id = ?
            ");
            $stmt->execute([$chemin_pdf, $produit_id]);
            
            if ($stmt->rowCount() === 0) {
                throw new Exception('Produit non trouvé');
            }
            
            echo json_encode([
                'success' => true,
                'message' => 'PDF mis à jour',
                'data' => [
                    'produit_id' => $produit_id,
                    'chemin_pdf' => $chemin_pdf
                ]
            ]);
            break;
        
        // POST /api.php?action=update_produit_status
        // Met à jour le statut d'un produit de commande
        case 'update_produit_status':
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                throw new Exception('Méthode POST requise');
            }
            
            $produit_id = $_POST['produit_id'] ?? $_GET['produit_id'] ?? '';
            $statut = $_POST['statut'] ?? $_GET['statut'] ?? '';
            
            if (empty($produit_id) || empty($statut)) {
                throw new Exception('produit_id et statut requis');
            }
            
            // Statuts valides
            $statuts_valides = ['nouvelle', 'pdf_genere', 'en_production', 'imprime', 'expedie'];
            if (!in_array($statut, $statuts_valides)) {
                throw new Exception('Statut invalide. Valeurs acceptées: ' . implode(', ', $statuts_valides));
            }
            
            $stmt = $pdo->prepare("
                UPDATE cmdeproduit 
                SET statut = ?
                WHERE id = ?
            ");
            $stmt->execute([$statut, $produit_id]);
            
            if ($stmt->rowCount() === 0) {
                throw new Exception('Produit non trouvé');
            }
            
            echo json_encode([
                'success' => true,
                'message' => 'Statut mis à jour',
                'data' => [
                    'produit_id' => $produit_id,
                    'statut' => $statut
                ]
            ]);
            break;
        
        // =================================================================
        // FAVORIS
        // =================================================================
        
        // GET /api.php?action=favoris&client_id=123
        // Récupère tous les favoris d'un client
        case 'favoris':
            $client_id = $_GET['client_id'] ?? null;
            
            if (!$client_id) {
                throw new Exception('client_id requis');
            }
            
            // D'abord récupérer les style_id des favoris
            $stmt = $pdo->prepare("
                SELECT style_id, created_at as favori_date
                FROM client_favoris 
                WHERE client_id = ?
                ORDER BY created_at DESC
            ");
            $stmt->execute([$client_id]);
            $favoriIds = $stmt->fetchAll();
            
            if (empty($favoriIds)) {
                echo json_encode([
                    'success' => true,
                    'data' => [],
                    'total' => 0
                ]);
                break;
            }
            
            // Récupérer les détails des styles
            $styleIds = array_column($favoriIds, 'style_id');
            $placeholders = implode(',', array_fill(0, count($styleIds), '?'));
            
            $stmt = $pdo->prepare("
                SELECT 
                    style_id,
                    titre,
                    theme,
                    categorie_slug,
                    categorie_nom,
                    descriptif,
                    url,
                    url2,
                    ordre,
                    background,
                    flag_champ_scene
                FROM styles 
                WHERE style_id IN ($placeholders) AND actif = TRUE
            ");
            $stmt->execute($styleIds);
            $styles = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // Indexer par style_id pour associer les dates
            $stylesById = [];
            foreach ($styles as $style) {
                $stylesById[$style['style_id']] = $style;
            }
            
            // Construire le résultat final avec les dates de favori
            $favoris = [];
            foreach ($favoriIds as $fav) {
                $sid = $fav['style_id'];
                if (isset($stylesById[$sid])) {
                    $style = $stylesById[$sid];
                    $style['favori_date'] = $fav['favori_date'];
                    $favoris[] = $style;
                }
            }
            
            echo json_encode([
                'success' => true,
                'data' => $favoris,
                'total' => count($favoris),
                'debug_ids' => $styleIds
            ]);
            break;
        
        // POST /api.php?action=add_favori
        // Ajoute un style aux favoris
        case 'add_favori':
            $data = json_decode(file_get_contents('php://input'), true);
            $client_id = $data['client_id'] ?? null;
            $style_id = $data['style_id'] ?? null;
            
            if (!$client_id || !$style_id) {
                throw new Exception('client_id et style_id requis');
            }
            
            // Vérifier si déjà en favori
            $stmt = $pdo->prepare("SELECT id FROM client_favoris WHERE client_id = ? AND style_id = ?");
            $stmt->execute([$client_id, $style_id]);
            
            if ($stmt->fetch()) {
                echo json_encode([
                    'success' => true,
                    'message' => 'Déjà en favori',
                    'already_exists' => true
                ]);
                break;
            }
            
            // Ajouter le favori
            $stmt = $pdo->prepare("INSERT INTO client_favoris (client_id, style_id) VALUES (?, ?)");
            $stmt->execute([$client_id, $style_id]);
            
            echo json_encode([
                'success' => true,
                'message' => 'Favori ajouté'
            ]);
            break;
        
        // POST /api.php?action=remove_favori
        // Supprime un style des favoris
        case 'remove_favori':
            $data = json_decode(file_get_contents('php://input'), true);
            $client_id = $data['client_id'] ?? null;
            $style_id = $data['style_id'] ?? null;
            
            if (!$client_id || !$style_id) {
                throw new Exception('client_id et style_id requis');
            }
            
            $stmt = $pdo->prepare("DELETE FROM client_favoris WHERE client_id = ? AND style_id = ?");
            $stmt->execute([$client_id, $style_id]);
            
            echo json_encode([
                'success' => true,
                'message' => 'Favori supprimé',
                'deleted' => $stmt->rowCount() > 0
            ]);
            break;
        
        // POST /api.php?action=toggle_favori
        // Ajoute ou supprime un favori (toggle)
        case 'toggle_favori':
            $data = json_decode(file_get_contents('php://input'), true);
            $client_id = $data['client_id'] ?? null;
            $style_id = $data['style_id'] ?? null;
            
            if (!$client_id || !$style_id) {
                throw new Exception('client_id et style_id requis');
            }
            
            // Vérifier si déjà en favori
            $stmt = $pdo->prepare("SELECT id FROM client_favoris WHERE client_id = ? AND style_id = ?");
            $stmt->execute([$client_id, $style_id]);
            
            if ($stmt->fetch()) {
                // Supprimer
                $stmt = $pdo->prepare("DELETE FROM client_favoris WHERE client_id = ? AND style_id = ?");
                $stmt->execute([$client_id, $style_id]);
                
                echo json_encode([
                    'success' => true,
                    'action' => 'removed',
                    'is_favori' => false
                ]);
            } else {
                // Ajouter
                $stmt = $pdo->prepare("INSERT INTO client_favoris (client_id, style_id) VALUES (?, ?)");
                $stmt->execute([$client_id, $style_id]);
                
                echo json_encode([
                    'success' => true,
                    'action' => 'added',
                    'is_favori' => true
                ]);
            }
            break;
        
        // =================================================================
        // NEWSLETTER
        // =================================================================
        
        // POST /api.php?action=newsletter_subscribe
        // Inscription à la newsletter
        case 'newsletter_subscribe':
            $data = json_decode(file_get_contents('php://input'), true);
            $email = $data['email'] ?? null;
            $client_id = $data['client_id'] ?? null;
            
            if (!$email) {
                throw new Exception('Email requis');
            }
            
            // Valider l'email
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                throw new Exception('Email invalide');
            }
            
            // Vérifier si déjà inscrit
            $stmt = $pdo->prepare("SELECT id, is_active FROM newsletter WHERE email = ?");
            $stmt->execute([$email]);
            $existing = $stmt->fetch();
            
            if ($existing) {
                if ($existing['is_active']) {
                    echo json_encode([
                        'success' => true,
                        'message' => 'Vous êtes déjà inscrit à notre newsletter !',
                        'already_subscribed' => true
                    ]);
                } else {
                    // Réactiver l'inscription
                    $stmt = $pdo->prepare("UPDATE newsletter SET is_active = TRUE, subscribed_at = CURRENT_TIMESTAMP WHERE email = ?");
                    $stmt->execute([$email]);
                    
                    echo json_encode([
                        'success' => true,
                        'message' => 'Votre inscription a été réactivée !',
                        'reactivated' => true
                    ]);
                }
            } else {
                // Nouvelle inscription
                $stmt = $pdo->prepare("INSERT INTO newsletter (email, client_id) VALUES (?, ?)");
                $stmt->execute([$email, $client_id]);
                
                echo json_encode([
                    'success' => true,
                    'message' => 'Merci pour votre inscription !'
                ]);
            }
            break;
        
        // POST /api.php?action=newsletter_unsubscribe
        // Désinscription de la newsletter
        case 'newsletter_unsubscribe':
            $data = json_decode(file_get_contents('php://input'), true);
            $email = $data['email'] ?? null;
            
            if (!$email) {
                throw new Exception('Email requis');
            }
            
            $stmt = $pdo->prepare("UPDATE newsletter SET is_active = FALSE WHERE email = ?");
            $stmt->execute([$email]);
            
            echo json_encode([
                'success' => true,
                'message' => 'Vous avez été désinscrit de la newsletter',
                'unsubscribed' => $stmt->rowCount() > 0
            ]);
            break;
        
        // GET /api.php?action=client_orders&client_id=123
        // Récupère les commandes d'un client
        case 'client_orders':
            $client_id = $_GET['client_id'] ?? null;
            
            if (!$client_id) {
                throw new Exception('ID client requis');
            }
            
            $stmt = $pdo->prepare("
                SELECT 
                    c.id,
                    c.created_at as date_commande,
                    c.total_price as montant_total,
                    c.statut_cmde,
                    c.date_expedition,
                    c.total_items as nb_articles
                FROM commande c
                WHERE c.user_id = ?
                ORDER BY c.created_at DESC
                LIMIT 50
            ");
            $stmt->execute([$client_id]);
            $orders = $stmt->fetchAll();
            
            echo json_encode([
                'success' => true,
                'data' => $orders,
                'total' => count($orders)
            ]);
            break;
        
        // GET /api.php?action=order_details&order_id=123
        // Récupère les détails d'une commande (produits)
        case 'order_details':
            $order_id = $_GET['order_id'] ?? null;
            
            if (!$order_id) {
                throw new Exception('ID commande requis');
            }
            
            $stmt = $pdo->prepare("
                SELECT 
                    cp.id,
                    cp.item_id,
                    cp.style,
                    cp.format,
                    cp.quantity,
                    cp.delivery,
                    cp.price,
                    cp.image_url,
                    cp.statut as statut_produit
                FROM cmdeproduit cp
                WHERE cp.commande_id = ?
                ORDER BY cp.id ASC
            ");
            $stmt->execute([$order_id]);
            $products = $stmt->fetchAll();
            
            echo json_encode([
                'success' => true,
                'data' => $products,
                'total' => count($products)
            ]);
            break;
        
        // POST /api.php?action=verify_promo
        // Vérifie et applique un code promo
        case 'verify_promo':
            $data = json_decode(file_get_contents('php://input'), true);
            $code = strtoupper(trim($data['code'] ?? ''));
            $montant_panier = floatval($data['montant'] ?? 0);
            
            if (empty($code)) {
                throw new Exception('Veuillez entrer un code promo');
            }
            
            // Rechercher le code promo
            $stmt = $pdo->prepare("
                SELECT * FROM code_promo 
                WHERE UPPER(code) = ?
            ");
            $stmt->execute([$code]);
            $promo = $stmt->fetch();
            
            if (!$promo) {
                throw new Exception('Code promo invalide');
            }
            
            // Vérifier si actif
            if (!$promo['actif']) {
                throw new Exception('Ce code promo n\'est plus actif');
            }
            
            // Vérifier la date de fin uniquement
            if (!empty($promo['date_fin']) && strtotime($promo['date_fin']) < time()) {
                throw new Exception('Ce code promo a expiré');
            }
            
            // Vérifier le nombre d'utilisations
            if ($promo['nb_utilisations_max'] !== null && $promo['nb_utilisations'] >= $promo['nb_utilisations_max']) {
                throw new Exception('Ce code promo a atteint sa limite d\'utilisation');
            }
            
            // Vérifier le montant minimum
            if ($promo['montant_min'] > 0 && $montant_panier < $promo['montant_min']) {
                throw new Exception('Montant minimum requis: ' . number_format($promo['montant_min'], 2) . ' €');
            }
            
            // Calculer la réduction
            $reduction = 0;
            if ($promo['type_reduction'] === 'pourcentage') {
                $reduction = $montant_panier * (floatval($promo['valeur']) / 100);
            } else {
                $reduction = min(floatval($promo['valeur']), $montant_panier);
            }
            
            echo json_encode([
                'success' => true,
                'data' => [
                    'code' => $promo['code'],
                    'description' => $promo['description'],
                    'type' => $promo['type_reduction'],
                    'valeur' => floatval($promo['valeur']),
                    'reduction' => round($reduction, 2),
                    'nouveau_total' => round($montant_panier - $reduction, 2)
                ]
            ]);
            break;
        
        // GET /api.php?action=tarifs
        // Récupère les tarifs par format depuis la base de données
        case 'tarifs':
            $stmt = $pdo->query("
                SELECT 
                    format,
                    label,
                    dimensions,
                    prix_1er,
                    prix_2eme,
                    prix_3eme_plus,
                    ordre
                FROM tarif_format 
                WHERE actif = TRUE 
                ORDER BY ordre ASC
            ");
            $tarifs = $stmt->fetchAll();
            
            // Transformer en format utilisable par le frontend
            $formats = [];
            foreach ($tarifs as $t) {
                $formats[$t['format']] = [
                    'label' => $t['label'],
                    'dim' => $t['dimensions'],
                    'prix' => floatval($t['prix_1er']),
                    'prix_1er' => floatval($t['prix_1er']),
                    'prix_2eme' => floatval($t['prix_2eme']),
                    'prix_3eme_plus' => floatval($t['prix_3eme_plus'])
                ];
            }
            
            echo json_encode([
                'success' => true,
                'data' => $formats
            ]);
            break;
        
        default:
            throw new Exception('Action invalide');
    }
    
} catch(Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>