var API_URL = 'list-pdfs-from-db.php';

var allOrders = [];
var currentFilter = 'all';
var currentFormatFilter = 'all';
var currentUrgenceFilter = 'all';

function loadOrders() {
    var content = document.getElementById('content');
    content.innerHTML = '<div class="loading"><div class="spinner"></div><p>Chargement des commandes...</p></div>';

    fetch(API_URL)
        .then(function(response) {
            if (!response.ok) {
                throw new Error('HTTP error! status: ' + response.status);
            }
            return response.json();
        })
        .then(function(data) {
            console.log('Données reçues de l\'API:', data);
            
            if (!data.success) {
                throw new Error(data.error || 'Erreur inconnue');
            }
            
            allOrders = data.commandes || [];
            console.log('Nombre total de commandes:', allOrders.length);
            
            updateStats(data.stats);
            populateFormatFilter();

            if (allOrders.length === 0) {
                content.innerHTML = '<div class="empty-state">' +
                    '<div class="empty-state-icon">📭</div>' +
                    '<h2>Aucune commande trouvée</h2>' +
                    '<p>Aucune commande dans la base de données.</p>' +
                    '</div>';
            } else {
                applyCurrentFilter();
            }
        })
        .catch(function(error) {
            console.error('Erreur:', error);
            content.innerHTML = '<div class="error">' +
                '<strong>❌ Erreur de chargement</strong><br>' +
                error.message + '<br>' +
                '<small>URL: ' + API_URL + '</small>' +
                '</div>';
        });
}

function applyCurrentFilter() {
    var filtered;
    
    if (currentFilter === 'all') {
        // Exclure les archives par défaut dans la vue "all"
        filtered = allOrders.filter(function(order) {
            var rawStatus = order.statut ? order.statut.toLowerCase() : 'traiter';
            var status = (rawStatus === 'pdf' || !order.statut) ? 'traiter' : rawStatus;
            return status !== 'archive';
        });
    } else {
        filtered = allOrders.filter(function(order) {
            var rawStatus = order.statut ? order.statut.toLowerCase() : 'traiter';
            var status = (rawStatus === 'pdf' || !order.statut) ? 'traiter' : rawStatus;
            return status === currentFilter.toLowerCase();
        });
    }
    
    if (currentFormatFilter === 'all' && currentUrgenceFilter === 'all') {
        displayOrders(filtered);
        displayActiveFilters();
        return;
    }
    
    var filteredOrders = filtered.filter(function(order) {
        if (!order.produits || order.produits.length === 0) {
            return false;
        }
        
        return order.produits.some(function(p) {
            var matchFormat = currentFormatFilter === 'all' || p.format === currentFormatFilter;
            
            // Comparaison directe avec la valeur exacte de la BDD
            var matchUrgence = currentUrgenceFilter === 'all' || p.delivery === currentUrgenceFilter;
            
            return matchFormat && matchUrgence;
        });
    });
    
    displayProducts(filteredOrders);
    displayActiveFilters();
}

function updateStats(stats) {
    if (stats) {
        var totalEl = document.getElementById('totalCount');
        var traiterEl = document.getElementById('traiterCount');
        var envoyerEl = document.getElementById('envoyerCount');
        var impressionEl = document.getElementById('impressionCount');  // AJOUTÉ
        var attenteEl = document.getElementById('attenteCount');
        var expedieEl = document.getElementById('expedieCount');
        var annulerEl = document.getElementById('annulerCount');
        var archiveEl = document.getElementById('archiveCount');
        
        if (totalEl) totalEl.textContent = stats.total || 0;
        
        if (traiterEl) {
            var traiterCount = (stats.nouveau || 0) + (stats.pdf || 0);
            traiterEl.textContent = traiterCount;
        }
        
        if (envoyerEl) envoyerEl.textContent = stats.envoyer || 0;
        if (impressionEl) impressionEl.textContent = stats.impression || 0;  // AJOUTÉ
        if (attenteEl) attenteEl.textContent = stats.attente || 0;
        if (expedieEl) expedieEl.textContent = stats.expedie || 0;
        if (annulerEl) annulerEl.textContent = stats.annuler || 0;
        if (archiveEl) archiveEl.textContent = stats.archive || 0;
    }
}

function displayOrders(orders) {
    var content = document.getElementById('content');
    
    if (orders.length === 0) {
        content.innerHTML = '<div class="empty-state">' +
            '<div class="empty-state-icon">🔍</div>' +
            '<h2>Aucun résultat</h2>' +
            '<p>Aucune commande ne correspond à ce filtre.</p>' +
            '</div>';
        return;
    }

    var grid = document.createElement('div');
    grid.className = 'orders-grid';

    orders.forEach(function(order) {
        var card = document.createElement('div');
        card.className = 'order-card';
        card.id = 'card-' + order.id;
        
        var rawStatus = order.statut ? order.statut.toLowerCase() : 'traiter';
        var statusClass = (rawStatus === 'pdf' || !order.statut) ? 'traiter' : rawStatus;
        var statusLabel = statusClass === 'traiter' ? 'À traiter' : (statusClass.charAt(0).toUpperCase() + statusClass.slice(1));
        var isExpedied = statusClass === 'expedie';

        var client = order.client || {};
        var clientNom = client.nom_complet || order.user_email || 'Client inconnu';
        var clientEmail = client.email || order.user_email || 'N/A';
        var clientTel = client.telephone || 'N/A';
        var clientAdresse = formatAdresse(client);

        var productsHTML = '';
        if (order.produits && order.produits.length > 0) {
            order.produits.forEach(function(p) {
                var vignette = p.chemin_vignette || p.image_url || '';
                var pdfUrl = p.chemin_pdf || p.pdf_url || '';
                var priceText = p.price ? p.price.toFixed(2) + '€' : '-';
                
                // Extraction des infos fichier
                var fileName = 'N/A';
                var fileSize = p.file_size || p.taille_fichier || null;
                var fileSizeText = 'N/A';
                var resolution = p.resolution || p.image_resolution || 'N/A';
                
                if (pdfUrl) {
                    // Extraire le nom du fichier depuis l'URL
                    var urlParts = pdfUrl.split('/');
                    fileName = urlParts[urlParts.length - 1];
                    // Décoder les caractères URL
                    fileName = decodeURIComponent(fileName);
                }
                
                // Formater la taille du fichier
                if (fileSize) {
                    if (fileSize > 1024 * 1024) {
                        fileSizeText = (fileSize / (1024 * 1024)).toFixed(2) + ' MB';
                    } else if (fileSize > 1024) {
                        fileSizeText = (fileSize / 1024).toFixed(2) + ' KB';
                    } else {
                        fileSizeText = fileSize + ' B';
                    }
                }
                
                // Infos techniques du fichier
                var fileInfoHTML = '<div class="product-file-info">' +
                    '<div class="file-info-item file-name" title="Nom du fichier"><span class="file-icon">📄</span> ' + fileName + '</div>' +
                    '<div class="file-info-row">' +
                    '<div class="file-info-item" title="Taille du fichier"><span class="file-icon">💾</span> ' + fileSizeText + '</div>' +
                    '<div class="file-info-item" title="Résolution"><span class="file-icon">📐</span> ' + resolution + '</div>' +
                    '</div>' +
                    '</div>';
                
                if (pdfUrl) {
                    var pdfUrlWithZoom = pdfUrl + '#zoom=50';
                    productsHTML += '<a href="' + pdfUrlWithZoom + '" target="_blank" class="product-item product-clickable" onclick="event.stopPropagation()" title="Ouvrir le PDF (zoom 50%)">' +
                        '<div class="product-thumb">' +
                        (vignette ? '<img src="' + vignette + '" alt="' + (p.style || '') + '" />' : '<div class="product-thumb-placeholder">🖼️</div>') +
                        '</div>' +
                        '<div class="product-details">' +
                        '<div class="product-style">' + (p.style || 'N/A') + '</div>' +
                        '<div class="product-meta">' + (p.format || 'N/A') + ' • x' + (p.quantity || 1) + ' • ' + (p.delivery || 'Standard') + '</div>' +
                        fileInfoHTML +
                        '</div>' +
                        '<div class="product-actions">' +
                        '<div class="product-price">' + priceText + '</div>' +
                        '<span class="pdf-indicator">📄</span>' +
                        '</div>' +
                        '</a>';
                } else {
                    productsHTML += '<div class="product-item">' +
                        '<div class="product-thumb">' +
                        (vignette ? '<img src="' + vignette + '" alt="' + (p.style || '') + '" />' : '<div class="product-thumb-placeholder">🖼️</div>') +
                        '</div>' +
                        '<div class="product-details">' +
                        '<div class="product-style">' + (p.style || 'N/A') + '</div>' +
                        '<div class="product-meta">' + (p.format || 'N/A') + ' • x' + (p.quantity || 1) + ' • ' + (p.delivery || 'Standard') + '</div>' +
                        fileInfoHTML +
                        '</div>' +
                        '<div class="product-actions">' +
                        '<div class="product-price">' + priceText + '</div>' +
                        '</div>' +
                        '</div>';
                }
            });
        }

        var expeditionHTML = '';
        if (isExpedied && order.date_expedition) {
            expeditionHTML = '<div class="expedition-info">' +
                '<div class="label">📅 Expédié le</div>' +
                '<div class="date">' + formatDate(order.date_expedition) + '</div>' +
                '</div>';
        }

// Boutons selon le statut - AVEC IMPRESSION
var buttonsHTML = '';
var isArchived = statusClass === 'archive';

if (isArchived) {
    // Commande archivée : aucun bouton
    buttonsHTML = '';
} else if (isExpedied) {
    // Commande expédiée : peut être archivée
    buttonsHTML = '<div class="status-buttons">' +
        '<button class="status-btn archive" onclick="updateStatus(' + order.id + ', \'archive\', event)" style="grid-column: span 2;">📦 Archiver</button>' +
        '</div>';
} else if (statusClass === 'annuler') {
    // Commande annulée : peut être archivée
    buttonsHTML = '<div class="status-buttons">' +
        '<button class="status-btn archive" onclick="updateStatus(' + order.id + ', \'archive\', event)" style="grid-column: span 2;">📦 Archiver</button>' +
        '</div>';
} else if (statusClass === 'impression') {
    // Commande en impression : peut être expédiée
    buttonsHTML = '<div class="status-buttons">' +
        '<button class="status-btn expedie" onclick="updateStatus(' + order.id + ', \'expedie\', event)" style="grid-column: span 2;">🚚 Expédier</button>' +
        '</div>';
} else if (statusClass === 'envoyer') {
    // Commande "À envoyer" : peut être mise en impression
    buttonsHTML = '<div class="status-buttons">' +
        '<button class="status-btn impression" onclick="updateStatus(' + order.id + ', \'impression\', event)" style="grid-column: span 2;">🖨️ En impression</button>' +
        '</div>';
} else if (statusClass === 'attente') {
    // Commande "En attente" : peut être envoyée ou annulée
    buttonsHTML = '<div class="status-buttons">' +
        '<button class="status-btn send" onclick="updateStatus(' + order.id + ', \'envoyer\', event)">✅ Envoyer</button>' +
        '<button class="status-btn cancel" onclick="updateStatus(' + order.id + ', \'annuler\', event)">❌ Annuler</button>' +
        '</div>';
} else {
    // Commande "À traiter" : peut être mise en attente ou envoyée
    buttonsHTML = '<div class="status-buttons">' +
        '<button class="status-btn send" onclick="updateStatus(' + order.id + ', \'envoyer\', event)">✅ Envoyer</button>' +
        '<button class="status-btn wait" onclick="updateStatus(' + order.id + ', \'attente\', event)">⏳ Attente</button>' +
        '</div>';
}


        var totalPrice = order.total_price ? order.total_price.toFixed(2) + '€' : '-';
        var productsCount = order.produits ? order.produits.length : 0;

        card.innerHTML = '<div class="order-header">' +
            '<div class="order-id">#' + order.id + '</div>' +
            '<div class="order-total">' + totalPrice + '</div>' +
            '</div>' +
            '<div class="order-info">' +
            '<div class="info-row"><span class="info-icon">👤</span><span>' + clientNom + '</span></div>' +
            '<div class="info-row"><span class="info-icon">📧</span><span>' + clientEmail + '</span></div>' +
            '<div class="info-row"><span class="info-icon">📱</span><span>' + clientTel + '</span></div>' +
            (clientAdresse ? '<div class="info-row"><span class="info-icon">📍</span><span>' + clientAdresse + '</span></div>' : '') +
            '<div class="info-row"><span class="info-icon">💳</span><span>' + (order.payment_method || 'N/A') + ' - ' + (order.payment_status || 'N/A') + '</span></div>' +
            '<div class="info-row"><span class="info-icon">📦</span><span>' + (order.total_items || 0) + ' article(s) - ' + (order.total_quantity || 0) + ' unité(s)</span></div>' +
            '<div class="info-row"><span class="info-icon">📅</span><span>' + formatDate(order.created_at) + '</span></div>' +
            '<div style="margin-top: 0.75rem;">' +
            '<span class="status-badge ' + statusClass + '">' + getStatusIcon(statusClass) + ' ' + statusLabel + '</span>' +
            '</div>' +
            expeditionHTML +
            '</div>' +
            '<div class="products-section">' +
            '<div class="products-title">Produits (' + productsCount + ')</div>' +
            (productsHTML || '<p style="opacity: 0.5; font-size: 0.85rem;">Aucun produit</p>') +
            '</div>' +
            buttonsHTML;

        grid.appendChild(card);
    });

    content.innerHTML = '';
    content.appendChild(grid);
}

function displayProducts(orders) {
    var content = document.getElementById('content');
    var products = [];
    
    orders.forEach(function(order) {
        if (!order.produits || order.produits.length === 0) return;
        
        order.produits.forEach(function(p) {
            var matchFormat = currentFormatFilter === 'all' || p.format === currentFormatFilter;
            
            // Comparaison directe avec la valeur exacte de la BDD
            var matchUrgence = currentUrgenceFilter === 'all' || p.delivery === currentUrgenceFilter;
            
            if (matchFormat && matchUrgence) {
                products.push({
                    product: p,
                    orderId: order.id,
                    orderStatus: order.statut
                });
            }
        });
    });
    
    if (products.length === 0) {
        content.innerHTML = '<div class="empty-state">' +
            '<div class="empty-state-icon">🔍</div>' +
            '<h2>Aucun produit trouvé</h2>' +
            '<p>Aucun produit ne correspond à ces filtres.</p>' +
            '</div>';
        return;
    }
    
    var grid = document.createElement('div');
    grid.className = 'products-grid';
    
    products.forEach(function(item) {
        var p = item.product;
        var vignette = p.chemin_vignette || p.image_url || '';
        var pdfUrl = p.chemin_pdf || p.pdf_url || '';
        var priceText = p.price ? p.price.toFixed(2) + '€' : '-';
        
        var rawStatus = item.orderStatus ? item.orderStatus.toLowerCase() : 'traiter';
        var statusClass = (rawStatus === 'pdf' || !item.orderStatus) ? 'traiter' : rawStatus;
        var statusLabel = statusClass === 'traiter' ? 'À traiter' : (statusClass.charAt(0).toUpperCase() + statusClass.slice(1));
        
        var card = document.createElement('div');
        card.className = 'product-card';
        
        var thumbHTML = '';
        if (pdfUrl) {
            var pdfUrlWithZoom = pdfUrl + '#zoom=50';
            thumbHTML = '<a href="' + pdfUrlWithZoom + '" target="_blank" class="product-card-link" title="Ouvrir le PDF (zoom 50%)">' +
                (vignette ? '<img src="' + vignette + '" alt="' + (p.style || '') + '" />' : 
                '<div class="product-card-placeholder">🖼️</div>') +
                '</a>';
        } else {
            thumbHTML = vignette ? '<img src="' + vignette + '" alt="' + (p.style || '') + '" />' : 
                '<div class="product-card-placeholder">🖼️</div>';
        }
        
        card.innerHTML = '<div class="product-card-image">' + thumbHTML + '</div>' +
            '<div class="product-card-info">' +
            '<div class="product-card-header">' +
            '<span class="product-card-style">' + (p.style || 'N/A') + '</span>' +
            '<span class="product-card-price">' + priceText + '</span>' +
            '</div>' +
            '<div class="product-card-meta">' +
            '<div class="meta-row"><span class="meta-icon">📐</span>' + (p.format || 'N/A') + '</div>' +
            '<div class="meta-row"><span class="meta-icon">📦</span>x' + (p.quantity || 1) + '</div>' +
            '<div class="meta-row"><span class="meta-icon">⚡</span>' + (p.delivery || 'Standard') + '</div>' +
            '</div>' +
            '<div class="product-card-footer">' +
            '<span class="order-id-small">#' + item.orderId + '</span>' +
            '<span class="status-badge ' + statusClass + '">' + getStatusIcon(statusClass) + ' ' + statusLabel + '</span>' +
            '</div>' +
            (pdfUrl ? '<a href="' + pdfUrl + '#zoom=50" target="_blank" class="product-card-pdf" title="Télécharger le PDF">📄 PDF</a>' : '') +
            '</div>';
        
        grid.appendChild(card);
    });
    
    content.innerHTML = '';
    content.appendChild(grid);
}

function formatAdresse(client) {
    if (!client) return '';
    
    var parts = [];
    if (client.adresse) parts.push(client.adresse);
    
    var villeParts = [];
    if (client.code_postal) villeParts.push(client.code_postal);
    if (client.ville) villeParts.push(client.ville);
    if (villeParts.length > 0) parts.push(villeParts.join(' '));
    
    if (client.pays && client.pays.toLowerCase() !== 'france') {
        parts.push(client.pays);
    }
    
    return parts.join(', ');
}

function getStatusIcon(status) {
    var icons = {
        'traiter': '📋',
        'nouveau': '🆕',
        'envoyer': '✅',
        'impression': '🖨️',  
        'attente': '⏳',
        'expedie': '🚚',
        'annuler': '❌',
        'archive': '📦'
    };
    return icons[status] || '📋';
}

function formatDate(dateString) {
    if (!dateString) return 'N/A';
    try {
        var date = new Date(dateString);
        if (isNaN(date.getTime())) return 'N/A';
        
        var day = ('0' + date.getDate()).slice(-2);
        var month = ('0' + (date.getMonth() + 1)).slice(-2);
        var year = date.getFullYear();
        var hours = ('0' + date.getHours()).slice(-2);
        var minutes = ('0' + date.getMinutes()).slice(-2);
        
        return day + '/' + month + '/' + year + ' ' + hours + ':' + minutes;
    } catch (e) {
        return 'N/A';
    }
}

function filterByStatus(status, element) {
    currentFilter = status;
    
    // Mettre à jour les cartes actives
    var statCards = document.querySelectorAll('.stat-card');
    statCards.forEach(function(card) {
        card.classList.remove('active');
    });
    
    if (element) {
        element.classList.add('active');
    }
    
    // Filtrer les commandes
    var filtered;
    if (status === 'all') {
        // MODIFIÉ : Exclure les commandes archivées du filtre "all"
        filtered = allOrders.filter(function(order) {
            var orderStatus = order.statut ? order.statut.toLowerCase() : 'pdf';
            return orderStatus !== 'archive';
        });
    } else if (status === 'traiter') {
        filtered = allOrders.filter(function(order) {
            var s = order.statut ? order.statut.toLowerCase() : 'pdf';
            return s === 'pdf' || s === 'nouveau' || s === '';
        });
    } else if (status === 'archive') {
        // Afficher UNIQUEMENT les commandes archivées
        filtered = allOrders.filter(function(order) {
            var s = order.statut ? order.statut.toLowerCase() : '';
            return s === 'archive';
        });
    } else {
        filtered = allOrders.filter(function(order) {
            var s = order.statut ? order.statut.toLowerCase() : 'pdf';
            return s === status;
        });
    }
    
    displayOrders(filtered);
}

function updateStatus(orderId, newStatus, event) {
    if (event) {
        event.stopPropagation();
    }
    
    var card = document.getElementById('card-' + orderId);
    if (!card) return;
    
    var overlay = document.createElement('div');
    overlay.className = 'loading-overlay';
    overlay.innerHTML = '<div class="loading-spinner"></div>';
    card.appendChild(overlay);
    
    fetch(API_URL, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            action: 'update_status',
            id: orderId,
            statut: newStatus
        })
    })
    .then(function(response) {
        return response.json();
    })
    .then(function(result) {
        if (!result.success) {
            throw new Error(result.error || 'Erreur inconnue');
        }
        
        var toastMessages = {
            'envoyer': '✅ Commande prête à envoyer',
            'impression': '🖨️ Commande en cours d\'impression',  // AJOUTÉ
            'attente': '⏳ Commande mise en attente',
            'expedie': '🚚 Commande expédiée !',
            'annuler': '❌ Commande annulée',
            'archive': '📦 Commande archivée'
        };
        var toastType = newStatus === 'expedie' ? 'purple' : (newStatus === 'annuler' ? 'error' : (newStatus === 'archive' ? 'info' : ''));
        showToast(toastMessages[newStatus] || 'Statut mis à jour', toastType);
        
        setTimeout(function() {
            loadOrders();
        }, 500);
    })
    .catch(function(error) {
        console.error('Erreur:', error);
        overlay.remove();
        showToast('Erreur: ' + error.message, 'error');
    });
}


function showToast(message, type) {
    var toast = document.getElementById('toast');
    if (!toast) return;
    
    toast.textContent = message;
    toast.className = 'toast' + (type ? ' ' + type : '');
    toast.classList.add('show');
    
    setTimeout(function() {
        toast.classList.remove('show');
    }, 3000);
}

function populateFormatFilter() {
    var formatFilter = document.getElementById('formatFilter');
    if (!formatFilter) return;
    
    var formats = new Set();
    
    allOrders.forEach(function(order) {
        if (order.produits && order.produits.length > 0) {
            order.produits.forEach(function(p) {
                if (p.format) {
                    formats.add(p.format);
                }
            });
        }
    });
    
    formatFilter.innerHTML = '<option value="all">Tous les formats</option>';
    
    Array.from(formats).sort().forEach(function(format) {
        var option = document.createElement('option');
        option.value = format;
        option.textContent = format;
        formatFilter.appendChild(option);
    });
}

function applyProductFilters() {
    var formatFilter = document.getElementById('formatFilter');
    var urgenceFilter = document.getElementById('urgenceFilter');
    
    currentFormatFilter = formatFilter ? formatFilter.value : 'all';
    currentUrgenceFilter = urgenceFilter ? urgenceFilter.value : 'all';
    
    applyCurrentFilter();
}

function resetProductFilters() {
    var formatFilter = document.getElementById('formatFilter');
    var urgenceFilter = document.getElementById('urgenceFilter');
    
    if (formatFilter) formatFilter.value = 'all';
    if (urgenceFilter) urgenceFilter.value = 'all';
    
    currentFormatFilter = 'all';
    currentUrgenceFilter = 'all';
    
    applyCurrentFilter();
}

function displayActiveFilters() {
    var container = document.getElementById('content');
    var existingBadges = document.querySelector('.active-filters');
    
    if (existingBadges) {
        existingBadges.remove();
    }
    
    if (currentFormatFilter === 'all' && currentUrgenceFilter === 'all') {
        return;
    }
    
    var badgesHTML = '<div class="active-filters">';
    
    if (currentFormatFilter !== 'all') {
        badgesHTML += '<div class="filter-badge">📐 ' + currentFormatFilter + 
            ' <button onclick="resetFormatFilter()">✖️</button></div>';
    }
    
    if (currentUrgenceFilter !== 'all') {
        badgesHTML += '<div class="filter-badge">⚡ ' + 
            currentUrgenceFilter.charAt(0).toUpperCase() + currentUrgenceFilter.slice(1) + 
            ' <button onclick="resetUrgenceFilter()">✖️</button></div>';
    }
    
    badgesHTML += '</div>';
    
    container.insertAdjacentHTML('afterbegin', badgesHTML);
}

function resetFormatFilter() {
    var formatFilter = document.getElementById('formatFilter');
    if (formatFilter) formatFilter.value = 'all';
    currentFormatFilter = 'all';
    applyCurrentFilter();
}

function resetUrgenceFilter() {
    var urgenceFilter = document.getElementById('urgenceFilter');
    if (urgenceFilter) urgenceFilter.value = 'all';
    currentUrgenceFilter = 'all';
    applyCurrentFilter();
}

document.addEventListener('DOMContentLoaded', function() {
    console.log('=== INITIALISATION ===');
    
    var searchInput = document.getElementById('searchInput');
    if (searchInput) {
        searchInput.addEventListener('input', function(e) {
            var searchTerm = e.target.value.toLowerCase().trim();
            
            var filtered;
            if (currentFilter === 'all') {
                // Exclure les archives par défaut dans la vue "all"
                filtered = allOrders.filter(function(order) {
                    var rawStatus = order.statut ? order.statut.toLowerCase() : 'traiter';
                    var status = (rawStatus === 'pdf' || !order.statut) ? 'traiter' : rawStatus;
                    return status !== 'archive';
                });
            } else {
                filtered = allOrders.filter(function(order) {
                    var rawStatus = order.statut ? order.statut.toLowerCase() : 'traiter';
                    var status = (rawStatus === 'pdf' || !order.statut) ? 'traiter' : rawStatus;
                    return status === currentFilter.toLowerCase();
                });
            }
            
            if (searchTerm) {
                filtered = filtered.filter(function(order) {
                    var matchOrder = 
                        (order.user_email && order.user_email.toLowerCase().indexOf(searchTerm) !== -1) ||
                        (order.payment_id && order.payment_id.toLowerCase().indexOf(searchTerm) !== -1) ||
                        (order.id && order.id.toString().indexOf(searchTerm) !== -1);
                    
                    var client = order.client || {};
                    var matchClient = 
                        (client.nom_complet && client.nom_complet.toLowerCase().indexOf(searchTerm) !== -1) ||
                        (client.nom && client.nom.toLowerCase().indexOf(searchTerm) !== -1) ||
                        (client.prenom && client.prenom.toLowerCase().indexOf(searchTerm) !== -1) ||
                        (client.email && client.email.toLowerCase().indexOf(searchTerm) !== -1) ||
                        (client.telephone && client.telephone.indexOf(searchTerm) !== -1) ||
                        (client.ville && client.ville.toLowerCase().indexOf(searchTerm) !== -1) ||
                        (client.code_postal && client.code_postal.indexOf(searchTerm) !== -1);
                    
                    var matchProduct = order.produits && order.produits.some(function(p) {
                        return (p.style && p.style.toLowerCase().indexOf(searchTerm) !== -1) ||
                            (p.format && p.format.toLowerCase().indexOf(searchTerm) !== -1) ||
                            (p.delivery && p.delivery.toLowerCase().indexOf(searchTerm) !== -1);
                    });
                    
                    return matchOrder || matchClient || matchProduct;
                });
            }
            
            displayOrders(filtered);
        });
    }

    loadOrders();
});