/**
 * Renderers pour les vues Upload, Génération et Résultat
 */

// Étendre ViewRenderers avec les vues d'upload
Object.assign(ViewRenderers, {
    /**
     * Vue Upload
     */
    renderUpload(app, state) {
        app.innerHTML = `
            <button class="btn btn-back" onclick="NavigationManager.backToStyles()">← Retour aux styles</button>
            <h1 class="section-title fade-in">Téléchargez votre photo</h1>
            ${state.selectedStyle ? `<p class="section-subtitle fade-in">Style sélectionné : <strong>${Utils.escapeHtml(state.selectedStyle.titre)}</strong></p>` : ''}
            
            <div class="upload-section fade-in">
                ${!state.uploadedPreview ? `
                    <div class="upload-zone" id="uploadZone" onclick="document.getElementById('fileInput').click()">
                        <div class="upload-icon">📸</div>
                        <h3 class="upload-title">Glissez votre image ici</h3>
                        <p class="upload-text">ou cliquez pour sélectionner</p>
                        <p class="upload-text" style="font-size: 0.85rem; margin-top: 8px;">JPG, PNG - Max 10 Mo</p>
                    </div>
                    <input type="file" id="fileInput" class="upload-input" accept="image/*" onchange="UploadManager.handleFileSelect(event)">
                ` : `
                    <div class="preview-container">
                        <img src="${state.uploadedPreview}" alt="Aperçu" class="preview-image fade-in">
                        <p class="preview-hint">💡 Peut être modifié pour chaque version</p>
                        <button class="btn btn-secondary" onclick="UploadManager.removeFile()">🗑️ Changer l'image</button>
                    </div>
                    
                    <div class="form-group">
                        <label>Titre de l'affiche (optionnel)</label>
                        <input 
                            type="text" 
                            class="form-control" 
                            placeholder="Ex: Nos vacances 2024" 
                            value="${state.imageTitle}"
                            onchange="StateManager.setState({ imageTitle: this.value })">
                    </div>
                    
                    ${state.selectedStyle && state.selectedStyle.flag_champ_scene ? `
                        <div class="form-group">
                            <label>Description de la scène (optionnel)</label>
                            <textarea 
                                class="form-control" 
                                rows="3" 
                                placeholder="Ex: Plage au coucher de soleil"
                                onchange="StateManager.setState({ sceneDescription: this.value })">${state.sceneDescription}</textarea>
                        </div>
                    ` : ''}
                    
                    <div class="form-group">
                        <label>Type de fond</label>
                        <div class="background-options">
                            <button class="bg-option ${state.backgroundType === 'blanc' ? 'active' : ''}" 
                                    onclick="StateManager.setState({ backgroundType: 'blanc' }); RenderManager.render()">
                                🤍 Fond blanc
                            </button>
                            <button class="bg-option ${state.backgroundType === 'colore' ? 'active' : ''}" 
                                    onclick="StateManager.setState({ backgroundType: 'colore' }); RenderManager.render()">
                                🎨 Fond coloré
                            </button>
                            <button class="bg-option ${state.backgroundType === 'ia' ? 'active' : ''}" 
                                    onclick="StateManager.setState({ backgroundType: 'ia' }); RenderManager.render()">
                                ✨ IA choisit
                            </button>
                        </div>
                    </div>
                    
                    <button class="btn btn-primary btn-large" onclick="UploadManager.generateImage()">
                        ✨ Générer mon affiche
                    </button>
                `}
            </div>
        `;
        
        // Setup drag & drop si nécessaire
        if (!state.uploadedPreview) {
            UploadManager.setupDragAndDrop();
        }
    },
    
    /**
     * Vue Génération en cours - Affiche les 3 zones
     */
    renderGenerating(app, state) {
        const generatingIndex = state.generatedImages.length; // Index de celle en cours
        
        app.innerHTML = `
            <button class="btn btn-back" onclick="NavigationManager.goHome()">← Retour à l'accueil</button>
            <h1 class="section-title fade-in">Génération en cours... 🎨</h1>
            <p class="section-subtitle fade-in" id="generationText">Notre IA travaille sur votre affiche unique</p>
            
            <div class="result-section fade-in">
                <!-- Grille des 3 zones -->
                <div class="versions-display-grid">
                    ${[0, 1, 2].map(index => {
                        const img = state.generatedImages[index];
                        
                        if (img) {
                            // Version déjà générée avec filigrane
                            return `
                                <div class="version-slot generated">
                                    <div class="version-image-container">
                                        <div class="watermarked-image">
                                            <img src="${img.url}" 
                                                 alt="Version ${img.version}" 
                                                 class="version-img">
                                            <div class="watermark-overlay"></div>
                                        </div>
                                        <div class="version-overlay">
                                            <span class="version-number-badge">V${img.version}</span>
                                        </div>
                                    </div>
                                    <div class="version-status">✅ Générée</div>
                                </div>
                            `;
                        } else if (index === generatingIndex) {
                            // Celle en cours de génération
                            return `
                                <div class="version-slot generating-slot">
                                    <div class="version-image-container generating">
                                        <div class="generating-animation">
                                            <div class="spinner"></div>
                                            <div class="generating-text" id="spinnerText">Contrôle des données...</div>
                                        </div>
                                    </div>
                                    <div class="version-status generating">⏳ En cours...</div>
                                </div>
                            `;
                        } else {
                            // Slot vide en attente
                            return `
                                <div class="version-slot empty-slot disabled">
                                    <div class="version-image-container empty">
                                        <div class="empty-placeholder">
                                            <div class="empty-icon">📷</div>
                                            <div class="empty-text">En attente</div>
                                        </div>
                                    </div>
                                </div>
                            `;
                        }
                    }).join('')}
                </div>
                
                <div class="generation-info">
                    <p>⏱️ Temps estimé : 30 à 60 secondes</p>
                </div>
            </div>
        `;
    },
    
    /**
     * Vue Résultat avec 3 zones toujours visibles
     */
    renderResult(app, state) {
        app.innerHTML = `
            <button class="btn btn-back" onclick="NavigationManager.goHome()">← Retour à l'accueil</button>
            <h1 class="section-title fade-in">Vos affiches générées ! 🎉</h1>
            <p class="section-subtitle fade-in">Sélectionnez les versions que vous souhaitez commander</p>
            
            <div class="result-section fade-in">
                <!-- Grille des 3 versions (toujours 3 zones) -->
                <div class="versions-display-grid">
                    ${[0, 1, 2].map(index => {
                        const img = state.generatedImages[index];
                        
                        if (img) {
                            // Version générée avec filigrane
                            return `
                                <div class="version-slot" id="version-${index}">
                                    <div class="version-image-container">
                                        <div class="watermarked-image">
                                            <img src="${img.url}" 
                                                 alt="Version ${img.version}" 
                                                 class="version-img"
                                                 onclick="UIManager.showImagePreview('${img.url}', 'Version ${img.version}')">
                                            <div class="watermark-overlay"></div>
                                        </div>
                                        <div class="version-overlay">
                                            <span class="version-number-badge">V${img.version}</span>
                                        </div>
                                    </div>
                                    
                                    <div class="version-checkbox-container">
                                        <label class="checkbox-wrapper">
                                            <input type="checkbox" 
                                                   id="select-version-${index}" 
                                                   class="version-checkbox"
                                                   onchange="VersionManager.toggleVersion(${index})">
                                            <span class="checkbox-custom"></span>
                                            <span class="checkbox-label-text">Sélectionner cette version</span>
                                        </label>
                                    </div>
                                </div>
                            `;
                        } else {
                            // Slot vide
                            return `
                                <div class="version-slot empty-slot">
                                    <button class="btn-generate-version" 
                                            onclick="StateManager.setState({ view: 'upload' }); RenderManager.render();"
                                            ${state.generatedImages.length >= 3 ? 'disabled' : ''}>
                                        <div class="generate-icon">+</div>
                                        <div class="generate-text">Générer une autre version</div>
                                    </button>
                                </div>
                            `;
                        }
                    }).join('')}
                </div>
                
                <!-- Barre d'actions -->
                <div class="result-actions-bar">
                    <div class="action-buttons">
                        <button class="btn btn-back" 
                                id="deselectAllBtn"
                                onclick="VersionManager.deselectAll()"
                                style="display: none;">
                            ✕ Tout désélectionner
                        </button>
                        
                        <button class="btn btn-primary btn-large" 
                                id="commanderBtn"
                                disabled
                                onclick="VersionManager.goToFormatSelection()">
                            📋 Choisir les formats
                        </button>
                    </div>
                </div>
            </div>
        `;
        
        // Initialiser le gestionnaire de versions
        if (typeof VersionManager !== 'undefined') {
            VersionManager.init();
        }
    },
    
    /**
     * Vue Result Generate - Formulaire en haut + 3 zones séquentielles
     */
    renderResultGenerate(app, state) {
        const currentSlot = state.generatedImages.length; // Index du slot à générer
        
        app.innerHTML = `
            <button class="btn btn-back" onclick="NavigationManager.goHome()">← Retour à l'accueil</button>
            <h1 class="section-title fade-in">Générez vos versions</h1>
            <p class="section-subtitle fade-in">Style : ${state.selectedStyle?.titre || ''}</p>
            
            <div class="result-section fade-in">
                <!-- Formulaire de génération en haut -->
                <div class="generation-form-top">
                    <div class="form-grid">
                        <!-- Upload Photo -->
                        <div class="form-group">
                            <label>📸 Votre photo *</label>
                            <div class="upload-area-main" 
                                 onclick="document.getElementById('file-input-main').click()">
                                <input type="file" 
                                       id="file-input-main" 
                                       accept="image/*,.heic"
                                       style="display: none"
                                       onchange="handleFileSelectMain(event)">
                                <div id="upload-preview-main" class="upload-preview-main">
                                    ${state.uploadedPreview ? 
                                        `<img src="${state.uploadedPreview}" alt="Aperçu" class="preview-img-main">` :
                                        `<div class="upload-placeholder-main">
                                            <div class="upload-icon-main">📁</div>
                                            <div class="upload-text-main">Cliquez pour choisir une photo</div>
                                            <div class="upload-hint-main">JPG, PNG (max 10 MB)</div>
                                        </div>`
                                    }
                                </div>
                            </div>
                            ${state.uploadedPreview ? `<p class="photo-hint">💡 Peut être modifié pour chaque version</p>` : ''}
                        </div>
                        
                        <div class="form-fields">
                            <!-- Titre -->
                            <div class="form-group">
                                <label>✏️ Titre de l'affiche (optionnel)</label>
                                <input type="text" 
                                       id="image-title-main" 
                                       class="form-control" 
                                       placeholder="Ex: Nos vacances à la mer"
                                       value="${state.imageTitle || ''}"
                                       onchange="StateManager.setState({ imageTitle: this.value })">
                                <small class="form-hint">💡 Peut être modifié pour chaque version</small>
                            </div>
                            
                            <!-- Description scène -->
                            ${state.selectedStyle && state.selectedStyle.flag_champ_scene ? `
                                <div class="form-group">
                                    <label>📝 Description de la scène (optionnel)</label>
                                    <textarea id="scene-description-main" 
                                              class="form-control" 
                                              rows="2"
                                              placeholder="Ex: Plage au coucher de soleil"
                                              onchange="StateManager.setState({ sceneDescription: this.value })">${state.sceneDescription || ''}</textarea>
                                    <small class="form-hint">💡 Peut être modifié pour chaque version</small>
                                </div>
                            ` : ''}
                            
                            <!-- Type de fond -->
                            <div class="form-group">
                                <label>🎨 Type de fond</label>
                                <div class="background-options-main">
                                    <button type="button" 
                                            class="bg-option-main ${(!state.backgroundType || state.backgroundType === 'ia') ? 'active' : ''}"
                                            data-bg="ia"
                                            onclick="document.querySelectorAll('.bg-option-main').forEach(b => b.classList.remove('active')); this.classList.add('active'); StateManager.setState({backgroundType: 'ia'})">
                                        <span class="bg-icon">✨</span>
                                        <span class="bg-label">IA choisit</span>
                                    </button>
                                    <button type="button"
                                            class="bg-option-main ${state.backgroundType === 'blanc' ? 'active' : ''}"
                                            data-bg="blanc"
                                            onclick="document.querySelectorAll('.bg-option-main').forEach(b => b.classList.remove('active')); this.classList.add('active'); StateManager.setState({backgroundType: 'blanc'})">
                                        <span class="bg-icon">🤍</span>
                                        <span class="bg-label">Fond blanc</span>
                                    </button>
                                    <button type="button"
                                            class="bg-option-main ${state.backgroundType === 'colore' ? 'active' : ''}"
                                            data-bg="colore"
                                            onclick="document.querySelectorAll('.bg-option-main').forEach(b => b.classList.remove('active')); this.classList.add('active'); StateManager.setState({backgroundType: 'colore'})">
                                        <span class="bg-icon">🎨</span>
                                        <span class="bg-label">Fond coloré</span>
                                    </button>
                                </div>
                                <small class="form-hint">💡 Peut être modifié pour chaque version</small>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Séparateur -->
                <div class="section-divider">
                    <span class="divider-text">Vos versions générées</span>
                </div>
                
                <!-- Grille des 3 versions -->
                <div class="versions-display-grid">
                    ${[0, 1, 2].map(index => {
                        const img = state.generatedImages[index];
                        const isCurrentSlot = index === currentSlot;
                        const isLocked = index > currentSlot;
                        
                        if (img) {
                            // Version déjà générée avec filigrane
                            return `
                                <div class="version-slot generated" id="version-${index}">
                                    <div class="version-header">
                                        <span class="version-badge success">✓ Version ${img.version}</span>
                                    </div>
                                    <div class="version-image-container">
                                        <div class="watermarked-image">
                                            <img src="${img.url}" 
                                                 alt="Version ${img.version}" 
                                                 class="version-img"
                                                 onclick="UIManager.showImagePreview('${img.url}', 'Version ${img.version}')">
                                            <div class="watermark-overlay"></div>
                                        </div>
                                    </div>
                                    
                                    <div class="version-checkbox-container">
                                        <label class="checkbox-wrapper">
                                            <input type="checkbox" 
                                                   id="select-version-${index}" 
                                                   class="version-checkbox"
                                                   onchange="VersionManager.toggleVersion(${index})">
                                            <span class="checkbox-custom"></span>
                                            <span class="checkbox-label-text">Sélectionner cette version</span>
                                        </label>
                                    </div>
                                </div>
                            `;
                        } else if (isCurrentSlot) {
                            // Slot actif pour générer
                            return `
                                <div class="version-slot active-slot" id="version-slot-${index}">
                                    <div class="version-header">
                                        <span class="version-badge active">⚡ Version ${index + 1} - Prête à générer</span>
                                    </div>
                                    <div class="slot-content">
                                        <div class="slot-info">
                                            <p class="slot-message">
                                                ${index === 0 ? 
                                                    '📸 Première version avec les paramètres ci-dessus' :
                                                    '✨ Vous pouvez modifier la photo, le titre, la description ou le fond avant de générer'
                                                }
                                            </p>
                                        </div>
                                        <button class="btn btn-primary btn-generate-main" 
                                                id="btn-generate-${index}"
                                                onclick="generateVersionFromMain(${index})"
                                                ${!state.uploadedFile ? 'disabled' : ''}>
                                            🎨 Générer la version ${index + 1}
                                        </button>
                                    </div>
                                </div>
                            `;
                        } else {
                            // Slot verrouillé (en attente)
                            return `
                                <div class="version-slot locked-slot">
                                    <div class="version-header">
                                        <span class="version-badge locked">🔒 Version ${index + 1}</span>
                                    </div>
                                    <div class="slot-content locked-content">
                                        <div class="locked-icon">🔒</div>
                                        <p class="locked-message">Générez d'abord la version ${currentSlot + 1}</p>
                                    </div>
                                </div>
                            `;
                        }
                    }).join('')}
                </div>
                
                <!-- Barre d'actions (apparaît dès qu'il y a 1+ version) -->
                ${state.generatedImages.length > 0 ? `
                    <div class="result-actions-bar">
                        <div class="action-buttons">
                            <button class="btn btn-back" 
                                    id="selectAllBtn"
                                    onclick="VersionManager.selectAll()">
                                ✓ Tout sélectionner
                            </button>
                            
                            <button class="btn btn-primary btn-large" 
                                    id="commanderBtn"
                                    disabled
                                    onclick="VersionManager.goToFormatSelection()">
                                📋 Choisir les formats
                            </button>
                        </div>
                    </div>
                ` : ''}
            </div>
        `;
        
        // Initialiser le gestionnaire de versions si nécessaire
        if (state.generatedImages.length > 0 && typeof VersionManager !== 'undefined') {
            VersionManager.init();
        }
    }
});