/**
 * Renderers pour les vues Order, Cart et Checkout
 */

// Étendre ViewRenderers avec les vues de commande
Object.assign(ViewRenderers, {
    /**
     * Vue Order - Configuration de la commande (image à droite, bouton sous l'image)
     */
    renderOrder(app, state) {
        const currentImage = state.generatedImages[state.currentVersion];
        
        app.innerHTML = `
            <button class="btn btn-back" onclick="NavigationManager.backToResult()">← Retour</button>
            
            <div class="order-minimal-container fade-in">
                <!-- Formulaire compact à gauche -->
                <div class="order-minimal-form">
                    <h2 class="order-minimal-title">Choisir vos formats</h2>
                    
                    <div id="formats-list">
                        ${Object.keys(CONFIG.FORMATS).map(formatKey => {
                            const format = CONFIG.FORMATS[formatKey];
                            return `
                                <div class="format-minimal-row" id="row-${formatKey}" data-format="${formatKey}">
                                    <div class="format-minimal-info">
                                        <span class="format-minimal-label">${format.label}</span>
                                        <span class="format-minimal-dim">${format.dim}</span>
                                        <span class="format-minimal-price">${Utils.formatPrice(format.prix)}</span>
                                    </div>
                                    
                                    <input type="number" 
                                           id="qty-${formatKey}" 
                                           class="qty-minimal-input" 
                                           value="0" 
                                           min="0" 
                                           max="999"
                                           placeholder="Qté"
                                           onchange="OrderManager.updateFormatQuantitySimple('${formatKey}', this.value)"
                                           oninput="OrderManager.updateFormatQuantitySimple('${formatKey}', this.value)">
                                </div>
                            `;
                        }).join('')}
                    </div>
                </div>
                
                <!-- Image à droite avec bouton dessous -->
                <div class="order-minimal-sidebar">
                    <div class="order-minimal-image">
                        <div class="watermarked-image">
                            <img src="${currentImage.url}" 
                                 alt="Version ${currentImage.version}" 
                                 class="order-minimal-img"
                                 onclick="UIManager.showImagePreview('${currentImage.url}', 'Version ${currentImage.version}')">
                            <div class="watermark-overlay"></div>
                        </div>
                        <span class="order-minimal-badge">V${currentImage.version}</span>
                    </div>
                    
                    <!-- Bouton unique d'ajout -->
                    <button class="btn btn-primary btn-large btn-add-cart" 
                            id="btn-add-all"
                            onclick="OrderManager.addAllSelectedFormats()"
                            disabled>
                        🛒 Ajouter au panier
                    </button>
                    
                    <!-- Actions secondaires -->
                    <div class="order-minimal-actions">
                        <button class="btn btn-secondary btn-sm" onclick="StateManager.setState({ view: 'cart' }); RenderManager.render();">
                            Voir panier (<span id="cart-count-min">${CartManager.getCartCount()}</span>)
                        </button>
                        
                        <button class="btn btn-secondary btn-sm" onclick="NavigationManager.continueShopping()">
                            Continuer
                        </button>
                    </div>
                </div>
            </div>
        `;
        
        // Initialiser
        if (typeof OrderManager !== 'undefined') {
            OrderManager.initFormatSelection(currentImage);
        }
    },
    
    /**
     * Vue Cart - Affichage du panier
     */
    renderCart(app, state) {
        const cartTotal = CartManager.getTotal();
        const totalUnits = CartManager.getTotalUnits();
        const totalWithPromo = CartManager.getTotalWithPromo();
        const hasPromo = CartManager.promoCode !== null;
        
        app.innerHTML = `
            <button class="btn btn-back" onclick="NavigationManager.goHome()">← Continuer mes achats</button>
            
            <h1 class="section-title fade-in">Mon panier</h1>
            
            ${state.cart.length === 0 ? `
                <div class="empty-cart fade-in">
                    <div class="empty-icon">🛒</div>
                    <h2>Votre panier est vide</h2>
                    <p>Créez votre première affiche personnalisée !</p>
                    <button class="btn btn-primary" onclick="NavigationManager.goHome()">
                        Découvrir nos styles
                    </button>
                </div>
            ` : `
                <div class="cart-compact-container fade-in">
                    <div class="cart-compact-list">
                        ${state.cart.map((item, index) => `
                            <div class="cart-compact-row">
                                <div class="cart-compact-image" onclick="UIManager.showImagePreview('${item.image}', '${item.styleName}')">
                                    <img src="${item.image}" alt="${item.styleName}">
                                </div>
                                
                                <div class="cart-compact-info">
                                    <span class="cart-compact-format">${item.formatLabel}</span>
                                    <span class="cart-compact-dim">${item.formatDim}</span>
                                </div>
                                
                                <div class="cart-compact-price">${Utils.formatPrice(item.unitPrice)}</div>
                                
                                <div class="qty-controls">
                                    <button class="qty-btn-s" onclick="CartManager.decrementQuantity('${item.id}'); RenderManager.render();">−</button>
                                    <input type="number" 
                                           value="${item.quantity}" 
                                           min="1" 
                                           max="1000"
                                           class="qty-input-s"
                                           onchange="CartManager.updateQuantity('${item.id}', this.value); RenderManager.render();">
                                    <button class="qty-btn-s" onclick="CartManager.incrementQuantity('${item.id}'); RenderManager.render();">+</button>
                                </div>
                                
                                <div class="cart-compact-total">${Utils.formatPrice(item.totalPrice)}</div>
                                
                                <button class="btn-remove-compact" onclick="CartManager.removeFromCart('${item.id}'); RenderManager.render();">
                                    🗑️
                                </button>
                            </div>
                        `).join('')}
                    </div>
                    
                    <!-- Résumé -->
                    <div class="cart-compact-summary">
                        <!-- Code Promo -->
                        <div class="promo-code-section">
                            <label class="promo-label">🎁 Code promo</label>
                            <div class="promo-code-form">
                                <input type="text" 
                                       id="promoCodeInput" 
                                       placeholder="Entrez votre code" 
                                       class="promo-code-input"
                                       value="${CartManager.promoCode || ''}"
                                       ${hasPromo ? 'disabled' : ''}
                                       onkeypress="if(event.key==='Enter'){applyPromoFromInput(); return false;}">
                                ${hasPromo ? `
                                    <button type="button" class="btn-promo-remove" onclick="CartManager.removePromoCode(); RenderManager.render();">
                                        ✕
                                    </button>
                                ` : `
                                    <button type="button" class="btn-promo-apply" onclick="applyPromoFromInput()">
                                        OK
                                    </button>
                                `}
                            </div>
                            <div id="promoErrorMsg" class="promo-error-msg" style="display: none;"></div>
                            ${hasPromo && CartManager.promoData ? `
                                <div class="promo-applied-info">
                                    <span class="promo-success">✅ ${CartManager.promoCode} <strong>(${CartManager.promoData.type === 'pourcentage' ? '-' + CartManager.promoData.valeur + '%' : '-' + CartManager.promoData.valeur + '€'})</strong></span>
                                    <span class="promo-discount-amount">-${CartManager.promoReduction.toFixed(2)} €</span>
                                </div>
                            ` : ''}
                        </div>
                        
                        <!-- Info dégressivité -->
                        <div class="cart-degressif-info">
                            <span>💡 <strong>-25%</strong> sur la 2ème affiche d'un même format</span>
                            <span>💡 <strong>-40%</strong> à partir de la 3ème</span>
                        </div>
                        
                        <div class="cart-summary-row">
                            <span>${totalUnits} article${totalUnits > 1 ? 's' : ''}</span>
                            ${hasPromo ? `
                                <span class="price-original">${Utils.formatPrice(cartTotal)}</span>
                            ` : `
                                <strong>${Utils.formatPrice(cartTotal)}</strong>
                            `}
                        </div>
                        
                        ${hasPromo ? `
                            <div class="cart-summary-row promo-row">
                                <span>Réduction ${CartManager.promoData ? (CartManager.promoData.type === 'pourcentage' ? '(' + CartManager.promoData.valeur + '%)' : '') : ''}</span>
                                <span class="promo-discount">-${CartManager.promoReduction.toFixed(2)} €</span>
                            </div>
                            <div class="cart-summary-row total-row">
                                <span><strong>Total à payer</strong></span>
                                <strong class="total-with-promo">${Utils.formatPrice(totalWithPromo)}</strong>
                            </div>
                        ` : ''}
                        
                        <div class="cart-compact-buttons">
                            <button class="btn btn-primary btn-compact" onclick="NavigationManager.proceedToCheckout()">
                                💳 Commander ${hasPromo ? Utils.formatPrice(totalWithPromo) : Utils.formatPrice(cartTotal)}
                            </button>
                            
                            <button class="btn btn-secondary btn-compact" onclick="NavigationManager.backToFormatSelection()">
                                📋 Ajouter d'autres formats
                            </button>
                        </div>
                        
                        <button class="btn-clear-cart" onclick="CartManager.clearCart()">
                            🗑️ Vider le panier
                        </button>
                    </div>
                </div>
            `}
        `;
    },
    
    /**
     * Vue Cart Added - Confirmation ajout au panier
     */
    renderCartAdded(app, state) {
        app.innerHTML = `
            <div class="cart-added-modal fade-in">
                <div class="success-icon">✅</div>
                <h2>Produit ajouté au panier !</h2>
                <p>Que souhaitez-vous faire ?</p>
                <div class="cart-added-actions">
                    <button class="btn btn-primary" onclick="NavigationManager.viewCart()">
                        🛒 Voir mon panier
                    </button>
                    <button class="btn btn-secondary" onclick="NavigationManager.goHome()">
                        ← Continuer mes achats
                    </button>
                </div>
            </div>
        `;
    },
    
    /**
     * Vue Checkout - Formulaire de commande
     */
    renderCheckout(app, state) {
        const cartTotal = CartManager.getTotal();
        const totalWithPromo = CartManager.getTotalWithPromo();
        const totalUnits = CartManager.getTotalUnits();
        const hasPromo = CartManager.promoCode !== null;
        const finalTotal = totalWithPromo;
        
        app.innerHTML = `
            <button class="btn btn-back" onclick="NavigationManager.viewCart()">← Retour au panier</button>
            
            <h1 class="section-title fade-in">Finaliser ma commande</h1>
            
            <form class="checkout-compact fade-in" onsubmit="OrderManager.submitCartOrder(event); return false;">
                
                <!-- Récap commande en haut -->
                <div class="checkout-recap">
                    <h3>📦 Récapitulatif</h3>
                    <div class="recap-items">
                        ${state.cart.map(item => `
                            <div class="recap-item">
                                <img src="${item.image}" alt="${item.styleName}">
                                <span class="recap-format">${item.formatLabel} × ${item.quantity}</span>
                                <span class="recap-price">${Utils.formatPrice(item.totalPrice)}</span>
                            </div>
                        `).join('')}
                    </div>
                    ${hasPromo ? `
                        <div class="recap-subtotal">
                            <span>Sous-total</span>
                            <span>${Utils.formatPrice(cartTotal)}</span>
                        </div>
                        <div class="recap-promo">
                            <span>🎁 ${CartManager.promoCode} ${CartManager.promoData ? (CartManager.promoData.type === 'pourcentage' ? '(-' + CartManager.promoData.valeur + '%)' : '') : ''}</span>
                            <span class="promo-discount">-${CartManager.promoReduction.toFixed(2)} €</span>
                        </div>
                    ` : ''}
                    <div class="recap-livraison">
                        <span>🚚 Livraison</span>
                        <span class="livraison-gratuite">Offerte</span>
                    </div>
                    <div class="recap-total">
                        <span>${totalUnits} article${totalUnits > 1 ? 's' : ''}</span>
                        <strong class="${hasPromo ? 'total-with-promo' : ''}">${Utils.formatPrice(finalTotal)}</strong>
                    </div>
                </div>
                
                <!-- Adresse de livraison -->
                <div class="checkout-address">
                    <h3>📍 Adresse de livraison</h3>
                    
                    <div class="address-grid">
                        <div class="form-group">
                            <label>Nom *</label>
                            <input type="text" required class="form-control" 
                                   value="${state.customer.name}"
                                   onchange="StateManager.setState({ customer: { ...StateManager.getState().customer, name: this.value } })">
                        </div>
                        
                        <div class="form-group">
                            <label>Prénom *</label>
                            <input type="text" required class="form-control" 
                                   value="${state.customer.prenom}"
                                   onchange="StateManager.setState({ customer: { ...StateManager.getState().customer, prenom: this.value } })">
                        </div>
                    </div>
                    
                    <div class="address-grid">
                        <div class="form-group">
                            <label>Email *</label>
                            <input type="email" required class="form-control" 
                                   value="${state.customer.email}"
                                   onchange="StateManager.setState({ customer: { ...StateManager.getState().customer, email: this.value } })">
                        </div>
                        
                        <div class="form-group">
                            <label>Téléphone *</label>
                            <input type="tel" required class="form-control" 
                                   value="${state.customer.phone}"
                                   onchange="StateManager.setState({ customer: { ...StateManager.getState().customer, phone: this.value } })">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Adresse *</label>
                        <input type="text" required class="form-control" 
                               value="${state.customer.address}"
                               onchange="StateManager.setState({ customer: { ...StateManager.getState().customer, address: this.value } })">
                    </div>
                    
                    <div class="address-grid">
                        <div class="form-group">
                            <label>Code postal *</label>
                            <input type="text" required class="form-control" 
                                   value="${state.customer.zip}"
                                   onchange="StateManager.setState({ customer: { ...StateManager.getState().customer, zip: this.value } })">
                        </div>
                        
                        <div class="form-group">
                            <label>Ville *</label>
                            <input type="text" required class="form-control" 
                                   value="${state.customer.city}"
                                   onchange="StateManager.setState({ customer: { ...StateManager.getState().customer, city: this.value } })">
                        </div>
                    </div>
                </div>
                
                <!-- CGV et boutons -->
                <div class="checkout-actions">
                    <label class="cgv-label">
                        <input type="checkbox" required>
                        <span>J'accepte les <a href="cgv.html" target="_blank">CGV</a> et la <a href="confidentialite.html" target="_blank">Politique de confidentialité</a> *</span>
                    </label>
                    
                    <div class="checkout-buttons">
                        <button type="button" class="btn btn-secondary btn-compact" onclick="NavigationManager.viewCart()">
                            ← Retour au panier
                        </button>
                        
                        <button type="submit" class="btn btn-primary btn-compact" ${state.isSubmitting ? 'disabled' : ''}>
                            💳 Payer ${Utils.formatPrice(finalTotal)}
                        </button>
                    </div>
                </div>
                
            </form>
        `;
    },
    
    /**
     * Vue Success - Commande réussie
     */
    renderSuccess(app, state) {
        const totalUnits = CartManager.getTotalUnits() || state.orderTotal?.units || 0;
        
        app.innerHTML = `
            <div class="success-container fade-in">
                <div class="success-card">
                    <!-- Animation confettis -->
                    <div class="confetti-container">
                        <div class="confetti"></div>
                        <div class="confetti"></div>
                        <div class="confetti"></div>
                        <div class="confetti"></div>
                        <div class="confetti"></div>
                    </div>
                    
                    <!-- Icône de succès -->
                    <div class="success-icon-wrapper">
                        <div class="success-checkmark">✓</div>
                    </div>
                    
                    <h1 class="success-heading">Merci pour votre commande !</h1>
                    
                    <p class="success-text">
                        Votre commande a bien été enregistrée.<br>
                        Vous recevrez un <strong>email de confirmation</strong> dans quelques instants.
                    </p>
                    
                    ${state.paymentId ? `
                        <div class="success-ref">
                            <span>N° de commande</span>
                            <strong>${state.paymentId}</strong>
                        </div>
                    ` : ''}
                    
                    <div class="success-next">
                        <p>📦 Vos affiches seront expédiées sous 3-5 jours ouvrés</p>
                    </div>
                    
                    <div class="success-actions">
                        <button class="btn btn-primary" onclick="NavigationManager.goHome()">
                            🎨 Créer une nouvelle affiche
                        </button>
                    </div>
                </div>
            </div>
        `;
    },
    
    /**
     * Vue Format Selection - Design minimaliste et compact
     */
    renderFormatSelection(app, state) {
        if (!state.selectedImagesForFormats || state.selectedImagesForFormats.length === 0) {
            NavigationManager.goHome();
            return;
        }
        
        const selectedImages = state.selectedImagesForFormats;
        
        app.innerHTML = `
            <button class="btn btn-back" onclick="NavigationManager.backToResult()">← Retour</button>
            
            <h1 class="section-title fade-in">Choisir vos formats</h1>
            <p class="section-subtitle fade-in">${selectedImages.length} version${selectedImages.length > 1 ? 's' : ''} sélectionnée${selectedImages.length > 1 ? 's' : ''}</p>
            
            <div class="format-selection-grid fade-in">
                ${selectedImages.map((item, idx) => `
                    <div class="format-card-minimal">
                        <!-- Image en haut -->
                        <div class="format-card-header">
                            <div class="format-card-image-small">
                                <div class="watermarked-image">
                                    <img src="${item.image.url}" alt="Version ${item.image.version}">
                                    <div class="watermark-overlay"></div>
                                </div>
                            </div>
                            <span class="format-version-badge">Version ${item.image.version}</span>
                        </div>
                        
                        <!-- Formats -->
                        <div class="format-card-body">
                            ${Object.keys(CONFIG.FORMATS).map(formatKey => {
                                const format = CONFIG.FORMATS[formatKey];
                                const prix1er = format.prix_1er || format.prix;
                                const prix2eme = format.prix_2eme || (prix1er * 0.75);
                                const prix3eme = format.prix_3eme_plus || (prix1er * 0.60);
                                return `
                                    <div class="format-row-simple" id="row-${idx}-${formatKey}">
                                        <div class="format-info-row">
                                            <span class="format-label-s">${format.label}</span>
                                            <span class="format-dim-s">${format.dim}</span>
                                        </div>
                                        <div class="format-prices-degressif">
                                            <span class="price-1er">${Utils.formatPrice(prix1er)}</span>
                                            <span class="price-degressif-info">la 2ème à -25%, à partir de la 3ème -40%</span>
                                        </div>
                                        <div class="qty-controls">
                                            <button class="qty-btn-s" onclick="FormatSelectionManager.decrementQuantity(${idx}, '${formatKey}')">−</button>
                                            <input type="text" 
                                                   id="qty-${idx}-${formatKey}" 
                                                   class="qty-input-s"
                                                   value="0" 
                                                   readonly
                                                   onclick="this.select()">
                                            <button class="qty-btn-s" onclick="FormatSelectionManager.incrementQuantity(${idx}, '${formatKey}')">+</button>
                                        </div>
                                    </div>
                                `;
                            }).join('')}
                        </div>
                    </div>
                `).join('')}
            </div>
            
            <!-- Bouton unique global -->
            <div class="format-global-actions fade-in">
                <div class="format-summary" id="formatSummary">
                    <span class="summary-count">0 article(s)</span>
                    <span class="summary-total">0,00 €</span>
                </div>
                <button class="btn btn-primary btn-large" 
                        id="btnAddAllToCart"
                        onclick="FormatSelectionManager.addAllToCart()"
                        disabled>
                    🛒 Ajouter au panier
                </button>
            </div>
        `;
        
        // Initialiser le gestionnaire
        if (typeof FormatSelectionManager !== 'undefined') {
            FormatSelectionManager.init(selectedImages);
        }
    },
    
    /**
     * Obtenir la description d'un format
     */
    getFormatDescription(formatKey) {
        const descriptions = {
            'A6': 'Idéal pour une carte postale',
            'A5': 'Parfait pour un petit cadre',
            'A4': 'Format standard polyvalent',
            'A3': 'Grande affiche décorative',
            'A2': 'Affiche murale imposante',
            'A1': 'Format XXL pour grand mur'
        };
        return descriptions[formatKey] || '';
    }
});

// Fonction globale pour appliquer le code promo depuis l'input
async function applyPromoFromInput() {
    const input = document.getElementById('promoCodeInput');
    if (input) {
        const code = input.value.trim();
        if (code) {
            const success = await CartManager.applyPromoCode(code);
            if (success) {
                RenderManager.render();
            }
        } else {
            Utils.showToast('❌ Veuillez entrer un code promo');
        }
    }
}