/**
 * Configuration globale de l'application
 */

const CONFIG = {
    // URLs API
    API_URL: 'api/api.php',
    WEBHOOK_GENERATE: 'https://n8n.img-conseil.fr/webhook/recreatoon',
    WEBHOOK_ORDER: 'https://n8n.img-conseil.fr/webhook/order',
    WEBHOOK_HEIC: 'https://n8n.img-conseil.fr/webhook/convert-heic-jpeg',
    IMAGE_BASE_URL: 'https://www.recreatoon.fr/IMG',
    
    // Formats d'impression
    FORMATS: {
        'A6': { prix: 4.90, label: 'A6', dim: '10×15 cm' },
        'A5': { prix: 9.90, label: 'A5', dim: '15×21 cm' },
        'A4': { prix: 19.90, label: 'A4', dim: '21×30 cm' },
        'A3': { prix: 29.90, label: 'A3', dim: '30×42 cm' },
        'A2': { prix: 39.90, label: 'A2', dim: '42×59 cm' },
        'A1': { prix: 59.90, label: 'A1', dim: '59×84 cm' }
    },
    
    // Tarifs dégressifs (par quantité du même format pour la même image)
    TARIFS: {
        // 1ère = prix plein (100%)
        // 2ème = -25% (75%)
        // 3ème et + = -40% (60%)
        reductions: {
            premier: 1.0,      // 100% du prix
            deuxieme: 0.75,    // 75% du prix (-25%)
            suivants: 0.60     // 60% du prix (-40%)
        }
    },
    
    // Quantités prédéfinies
    GRID_QUANTITIES: [1, 2, 5, 10, 15, 20, 30, 50, 75, 100, 150, 200, 300, 500, 750, 1000],
    
    // Icônes des catégories
    CATEGORY_ICONS: {
        'affiche-couple': '💑',
        'affiche-famille': '👨‍👩‍👧‍👦',
        'affiche-parents': '👪',
        'affiche-illustration': '🎨',
        'affiche-carte-lieu': '🗺️',
        'affiche-pop-culture': '🎬',
        'affiche-citation-texte': '💬',
        'affiche-naissance-bebe': '👶',
        'affiche-occasion': '🎉'
    }
};

// Export pour ES6 modules
if (typeof module !== 'undefined' && module.exports) {
    module.exports = CONFIG;
}
