<?php
/**
 * API Newsletter - Récréatoon
 * Enregistre les emails dans la table newsletter
 */

// Headers CORS et JSON
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Gestion des requêtes OPTIONS (preflight CORS)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Vérifier que c'est une requête POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Méthode non autorisée']);
    exit();
}

// Configuration de la base de données
$dbConfig = [
    'host' => 'oz9643-001.eu.clouddb.ovh.net',
    'port' => '35297',
    'dbname' => 'recreatoon_DDB',
    'user' => 'user_recreatoon',
    'password' => 'MathelodIMG59'
];

// Récupérer les données POST
$input = json_decode(file_get_contents('php://input'), true);
$email = isset($input['email']) ? trim($input['email']) : '';

// Si pas de JSON, essayer les données de formulaire classiques
if (empty($email) && isset($_POST['email'])) {
    $email = trim($_POST['email']);
}

// Validation de l'email
if (empty($email)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Email requis']);
    exit();
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Email invalide']);
    exit();
}

try {
    // Connexion à la base de données PostgreSQL
    $dsn = "pgsql:host={$dbConfig['host']};port={$dbConfig['port']};dbname={$dbConfig['dbname']}";
    $pdo = new PDO(
        $dsn,
        $dbConfig['user'],
        $dbConfig['password'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
    
    // Vérifier si l'email existe déjà
    $checkStmt = $pdo->prepare("SELECT id, is_active FROM newsletter WHERE email = :email");
    $checkStmt->execute(['email' => $email]);
    $existing = $checkStmt->fetch();
    
    if ($existing) {
        // Email existe déjà
        if ($existing['is_active']) {
            echo json_encode([
                'success' => true, 
                'message' => 'Tu es déjà inscrit(e) ! On te préviendra dès le lancement 🦝'
            ]);
        } else {
            // Réactiver l'inscription
            $updateStmt = $pdo->prepare("UPDATE newsletter SET is_active = true, subscribed_at = NOW() WHERE id = :id");
            $updateStmt->execute(['id' => $existing['id']]);
            echo json_encode([
                'success' => true, 
                'message' => 'Content de te revoir ! Tu es de nouveau inscrit(e) 🎉'
            ]);
        }
    } else {
        // Nouvel email - Insérer
        $insertStmt = $pdo->prepare("
            INSERT INTO newsletter (email, subscribed_at, is_active) 
            VALUES (:email, NOW(), true)
        ");
        $insertStmt->execute(['email' => $email]);
        
        echo json_encode([
            'success' => true, 
            'message' => 'Super ! Tu seras prévenu(e) dès le lancement de Récréatoon 🚀'
        ]);
    }
    
} catch (PDOException $e) {
    // Erreur de base de données
    http_response_code(500);
    echo json_encode([
        'success' => false, 
        'message' => 'Oups ! Une erreur est survenue. Réessaie plus tard.'
    ]);
}
?>