<?php
/**
 * GESTIONNAIRE DE COMMANDES - AVEC AUTHENTIFICATION
 */

// Configuration BDD
define('DB_HOST', 'oz9643-001.eu.clouddb.ovh.net');
define('DB_PORT', '35297');
define('DB_USER', 'user_recreatoon');
define('DB_PASS', 'MathelodIMG59');
define('DB_NAME', 'recreatoon_DDB');

// ============================================
// AUTHENTIFICATION
// ============================================
session_start();

function checkAuth() {
    try {
        $dsn = sprintf("pgsql:host=%s;port=%s;dbname=%s", DB_HOST, DB_PORT, DB_NAME);
        $pdo = new PDO($dsn, DB_USER, DB_PASS, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]);
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login']) && isset($_POST['password'])) {
            $login = $_POST['login'];
            $password = $_POST['password'];
            
            // Récupérer l'utilisateur par son login
            $stmt = $pdo->prepare('SELECT * FROM auth_access WHERE login = ?');
            $stmt->execute([$login]);
            $user = $stmt->fetch();
            
            // Vérifier le mot de passe hashé
            if ($user && password_verify($password, $user['mdp'])) {
                $_SESSION['auth'] = true;
                $_SESSION['login'] = $login;
                return true;
            } else {
                return false;
            }
        }
        
        return isset($_SESSION['auth']) && $_SESSION['auth'] === true;
    } catch (PDOException $e) {
        error_log("Auth error: " . $e->getMessage());
        return false;
    }
}

// Déconnexion
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Vérifier l'authentification
if (!checkAuth()) {
    $error = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
        $error = 'Login ou mot de passe incorrect';
    }
    ?>
    <!DOCTYPE html>
    <html lang="fr">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Connexion - Gestionnaire de Commandes</title>
        <style>
            * { box-sizing: border-box; margin: 0; padding: 0; }
            body {
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
                background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            .login-container {
                background: rgba(255,255,255,0.05);
                border: 1px solid rgba(255,255,255,0.1);
                border-radius: 16px;
                padding: 40px;
                width: 100%;
                max-width: 400px;
                backdrop-filter: blur(10px);
            }
            h1 {
                color: #fff;
                text-align: center;
                margin-bottom: 30px;
                font-size: 1.8rem;
            }
            .form-group {
                margin-bottom: 20px;
            }
            label {
                display: block;
                color: #a0a0a0;
                margin-bottom: 8px;
                font-size: 0.9rem;
            }
            input {
                width: 100%;
                padding: 12px 16px;
                border: 1px solid rgba(255,255,255,0.2);
                border-radius: 8px;
                background: rgba(255,255,255,0.05);
                color: #fff;
                font-size: 1rem;
            }
            input:focus {
                outline: none;
                border-color: #6366f1;
            }
            button {
                width: 100%;
                padding: 14px;
                background: linear-gradient(135deg, #6366f1, #8b5cf6);
                border: none;
                border-radius: 8px;
                color: #fff;
                font-size: 1rem;
                font-weight: 600;
                cursor: pointer;
                transition: transform 0.2s, box-shadow 0.2s;
            }
            button:hover {
                transform: translateY(-2px);
                box-shadow: 0 10px 20px rgba(99, 102, 241, 0.3);
            }
            .error {
                background: rgba(239, 68, 68, 0.2);
                border: 1px solid rgba(239, 68, 68, 0.5);
                color: #fca5a5;
                padding: 12px;
                border-radius: 8px;
                margin-bottom: 20px;
                text-align: center;
            }
        </style>
    </head>
    <body>
        <div class="login-container">
            <h1>📦 Commandes</h1>
            <?php if ($error): ?>
                <div class="error"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            <form method="POST">
                <div class="form-group">
                    <label>Login</label>
                    <input type="text" name="login" required autofocus>
                </div>
                <div class="form-group">
                    <label>Mot de passe</label>
                    <input type="password" name="password" required>
                </div>
                <button type="submit">Se connecter</button>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestionnaire de Commandes - IMG Conseil</title>
    <link href="https://fonts.googleapis.com/css2?family=Bebas+Neue&family=Work+Sans:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="viewer.css">
    <link rel="stylesheet" href="file-info-styles.css">
</head>
<body>
    <div class="container">
        <header style="display: flex; justify-content: space-between; align-items: center;">
            <div>
                <h1 class="logo">📦 COMMANDES</h1>
                <p class="subtitle">Gestionnaire de commandes</p>
            </div>
            <a href="?logout=1" style="background: rgba(239,68,68,0.2); border: 1px solid rgba(239,68,68,0.5); color: #fca5a5; padding: 8px 16px; border-radius: 8px; text-decoration: none; font-size: 0.9rem;">🚪 Déconnexion (<?= htmlspecialchars($_SESSION['login'] ?? '') ?>)</a>
        </header>

        <div class="stats-bar">
            <div class="stat-card active" onclick="filterByStatus('all', this)">
                <span class="stat-icon">📄</span>
                <div class="stat-label">Total Pipe de commande</div>
                <div class="stat-value" id="totalCount">-</div>
            </div>
            <div class="stat-card" onclick="filterByStatus('traiter', this)">
                <div class="stat-icon">📋</div>
                <div class="stat-label">Nouvelles Commandes</div>
                <div class="stat-value" id="traiterCount">0</div>
            </div>
            <div class="stat-card" onclick="filterByStatus('envoyer', this)">
                <span class="stat-icon">✅</span>
                <div class="stat-label">Envoyer en Impression</div>
                <div class="stat-value" id="envoyerCount">-</div>
            </div>
            <div class="stat-card" onclick="filterByStatus('attente', this)">
                <span class="stat-icon">⏳</span>
                <div class="stat-label">Litige</div>
                <div class="stat-value" id="attenteCount">-</div>
            </div>
            <div class="stat-card" onclick="filterByStatus('impression', this)">
                <span class="stat-icon">🖨️</span>
                <div class="stat-label">En cours de prod</div>
                <div class="stat-value" id="impressionCount">-</div>
            </div>
            <div class="stat-card" onclick="filterByStatus('expedie', this)">
                <span class="stat-icon">🚚</span>
                <div class="stat-label">Expédiés</div>
                <div class="stat-value" id="expedieCount">-</div>
            </div>
            <div class="stat-card" onclick="filterByStatus('annuler', this)">
                <span class="stat-icon">❌</span>
                <div class="stat-label">Annulés</div>
                <div class="stat-value" id="annulerCount">-</div>
            </div>
            <div class="stat-card" onclick="filterByStatus('archive', this)">
                <span class="stat-icon">📦</span>
                <div class="stat-label">Archivés</div>
                <div class="stat-value" id="archiveCount">-</div>
            </div>
        </div>

        <div class="controls">
            <div class="search-box">
                <span class="search-icon">🔍</span>
                <input type="text" id="searchInput" placeholder="Rechercher par nom, email, commande, ville...">
            </div>
            <button class="btn" onclick="loadOrders()">🔄 Actualiser</button>
        </div>

        <div class="product-filters">
            <div class="filter-group">
                <label class="filter-label">📐 Format</label>
                <select id="formatFilter" onchange="applyProductFilters()">
                    <option value="all">Tous les formats</option>
                </select>
            </div>
            
            <div class="filter-group">
                <label class="filter-label">⚡ Priorités</label>
                <select id="urgenceFilter" onchange="applyProductFilters()">
                    <option value="all">Toutes les priorités</option>
                    <option value="Économique">Économique</option>
                    <option value="Standard">Standard</option>
                    <option value="Urgent">Urgent</option>
                </select>
            </div>
            
            <button class="btn-reset" onclick="resetProductFilters()">
                ✖️ Réinitialiser
            </button>
        </div>

        <div id="content">
            <div class="loading">
                <div class="spinner"></div>
                <p>Chargement des commandes...</p>
            </div>
        </div>
    </div>

    <div class="toast" id="toast"></div>

    <script src="viewer.js"></script>
</body>
</html>
