<?php
/**
 * Gestion des accès admin - Récréatoon
 * Fichier autonome pour gérer la table auth_access
 */

session_start();

// Configuration BDD
$dbConfig = [
    'host' => 'oz9643-001.eu.clouddb.ovh.net',
    'port' => '35297',
    'dbname' => 'recreatoon_DDB',
    'user' => 'user_recreatoon',
    'password' => 'MathelodIMG59'
];

// Connexion BDD
function getDB($config) {
    try {
        $dsn = "pgsql:host={$config['host']};port={$config['port']};dbname={$config['dbname']}";
        return new PDO($dsn, $config['user'], $config['password'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]);
    } catch (PDOException $e) {
        die("Erreur de connexion : " . $e->getMessage());
    }
}

$pdo = getDB($dbConfig);
$message = '';
$messageType = '';

// Traitement des actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Ajout d'un utilisateur
    if (isset($_POST['action']) && $_POST['action'] === 'add') {
        $login = trim($_POST['login'] ?? '');
        $mdp = trim($_POST['mdp'] ?? '');
        
        if ($login && $mdp) {
            try {
                // Vérifier si le login existe déjà
                $check = $pdo->prepare("SELECT id FROM auth_access WHERE login = ?");
                $check->execute([$login]);
                
                if ($check->fetch()) {
                    $message = "❌ Ce login existe déjà !";
                    $messageType = 'error';
                } else {
                    // Hasher le mot de passe
                    $hashedMdp = password_hash($mdp, PASSWORD_DEFAULT);
                    
                    $stmt = $pdo->prepare("INSERT INTO auth_access (login, mdp) VALUES (?, ?)");
                    $stmt->execute([$login, $hashedMdp]);
                    
                    $message = "✅ Utilisateur '$login' ajouté avec succès !";
                    $messageType = 'success';
                }
            } catch (PDOException $e) {
                $message = "❌ Erreur : " . $e->getMessage();
                $messageType = 'error';
            }
        } else {
            $message = "❌ Login et mot de passe requis !";
            $messageType = 'error';
        }
    }
    
    // Suppression d'un utilisateur
    if (isset($_POST['action']) && $_POST['action'] === 'delete') {
        $id = intval($_POST['id'] ?? 0);
        
        if ($id > 0) {
            try {
                $stmt = $pdo->prepare("DELETE FROM auth_access WHERE id = ?");
                $stmt->execute([$id]);
                
                $message = "✅ Utilisateur supprimé !";
                $messageType = 'success';
            } catch (PDOException $e) {
                $message = "❌ Erreur : " . $e->getMessage();
                $messageType = 'error';
            }
        }
    }
    
    // Modification du mot de passe
    if (isset($_POST['action']) && $_POST['action'] === 'update_mdp') {
        $id = intval($_POST['id'] ?? 0);
        $newMdp = trim($_POST['new_mdp'] ?? '');
        
        if ($id > 0 && $newMdp) {
            try {
                $hashedMdp = password_hash($newMdp, PASSWORD_DEFAULT);
                
                $stmt = $pdo->prepare("UPDATE auth_access SET mdp = ? WHERE id = ?");
                $stmt->execute([$hashedMdp, $id]);
                
                $message = "✅ Mot de passe modifié !";
                $messageType = 'success';
            } catch (PDOException $e) {
                $message = "❌ Erreur : " . $e->getMessage();
                $messageType = 'error';
            }
        } else {
            $message = "❌ Nouveau mot de passe requis !";
            $messageType = 'error';
        }
    }
}

// Récupérer tous les utilisateurs
$users = $pdo->query("SELECT id, login FROM auth_access ORDER BY id")->fetchAll();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🔐 Gestion des accès - Récréatoon</title>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700;800&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Nunito', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 40px 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
        }
        
        h1 {
            color: white;
            text-align: center;
            margin-bottom: 30px;
            font-size: 2rem;
            text-shadow: 0 2px 10px rgba(0,0,0,0.2);
        }
        
        .card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 25px;
            box-shadow: 0 15px 40px rgba(0,0,0,0.15);
        }
        
        .card h2 {
            color: #2d3748;
            margin-bottom: 20px;
            font-size: 1.3rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .message {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        .message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .form-row {
            display: flex;
            gap: 15px;
            margin-bottom: 15px;
            flex-wrap: wrap;
        }
        
        .form-group {
            flex: 1;
            min-width: 200px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #4a5568;
        }
        
        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 12px 18px;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-size: 1rem;
            font-family: 'Nunito', sans-serif;
            transition: border-color 0.2s;
        }
        
        input:focus {
            outline: none;
            border-color: #667eea;
        }
        
        button {
            padding: 12px 25px;
            border: none;
            border-radius: 10px;
            font-size: 1rem;
            font-weight: 700;
            font-family: 'Nunito', sans-serif;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        
        button:hover {
            transform: translateY(-2px);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-primary:hover {
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }
        
        .btn-danger {
            background: #e53e3e;
            color: white;
            padding: 8px 15px;
            font-size: 0.9rem;
        }
        
        .btn-warning {
            background: #ed8936;
            color: white;
            padding: 8px 15px;
            font-size: 0.9rem;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        th, td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }
        
        th {
            background: #f7fafc;
            font-weight: 700;
            color: #4a5568;
        }
        
        tr:hover {
            background: #f7fafc;
        }
        
        .actions {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        
        .user-count {
            background: #667eea;
            color: white;
            padding: 3px 12px;
            border-radius: 20px;
            font-size: 0.9rem;
        }
        
        .back-link {
            display: inline-block;
            margin-bottom: 20px;
            color: white;
            text-decoration: none;
            font-weight: 600;
            opacity: 0.9;
        }
        
        .back-link:hover {
            opacity: 1;
            text-decoration: underline;
        }
        
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }
        
        .modal.show {
            display: flex;
        }
        
        .modal-content {
            background: white;
            padding: 30px;
            border-radius: 20px;
            max-width: 400px;
            width: 90%;
        }
        
        .modal-content h3 {
            margin-bottom: 20px;
            color: #2d3748;
        }
        
        @media (max-width: 600px) {
            .form-row { flex-direction: column; }
            .actions { flex-direction: column; }
            button { width: 100%; }
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="/BO/" class="back-link">← Retour au Back Office</a>
        
        <h1>🔐 Gestion des accès</h1>
        
        <?php if ($message): ?>
            <div class="message <?= $messageType ?>"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
        
        <!-- Formulaire d'ajout -->
        <div class="card">
            <h2>➕ Ajouter un utilisateur</h2>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="form-row">
                    <div class="form-group">
                        <label for="login">Login</label>
                        <input type="text" id="login" name="login" required placeholder="admin">
                    </div>
                    <div class="form-group">
                        <label for="mdp">Mot de passe</label>
                        <input type="password" id="mdp" name="mdp" required placeholder="••••••••">
                    </div>
                </div>
                <button type="submit" class="btn-primary">Ajouter l'utilisateur</button>
            </form>
        </div>
        
        <!-- Liste des utilisateurs -->
        <div class="card">
            <h2>👥 Utilisateurs existants <span class="user-count"><?= count($users) ?></span></h2>
            
            <?php if (empty($users)): ?>
                <p style="color: #718096; text-align: center; padding: 20px;">Aucun utilisateur pour le moment.</p>
            <?php else: ?>
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Login</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): ?>
                            <tr>
                                <td><?= $user['id'] ?></td>
                                <td><strong><?= htmlspecialchars($user['login']) ?></strong></td>
                                <td>
                                    <div class="actions">
                                        <button type="button" class="btn-warning" onclick="openModal(<?= $user['id'] ?>, '<?= htmlspecialchars($user['login']) ?>')">
                                            🔑 Changer MDP
                                        </button>
                                        <form method="POST" style="display: inline;" onsubmit="return confirm('Supprimer <?= htmlspecialchars($user['login']) ?> ?')">
                                            <input type="hidden" name="action" value="delete">
                                            <input type="hidden" name="id" value="<?= $user['id'] ?>">
                                            <button type="submit" class="btn-danger">🗑️ Supprimer</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Modal changement de mot de passe -->
    <div class="modal" id="mdpModal">
        <div class="modal-content">
            <h3>🔑 Changer le mot de passe</h3>
            <form method="POST">
                <input type="hidden" name="action" value="update_mdp">
                <input type="hidden" name="id" id="modal_user_id">
                <p style="margin-bottom: 15px; color: #4a5568;">Utilisateur : <strong id="modal_user_login"></strong></p>
                <div class="form-group" style="margin-bottom: 20px;">
                    <label for="new_mdp">Nouveau mot de passe</label>
                    <input type="password" id="new_mdp" name="new_mdp" required placeholder="••••••••">
                </div>
                <div style="display: flex; gap: 10px;">
                    <button type="submit" class="btn-primary">Modifier</button>
                    <button type="button" class="btn-danger" onclick="closeModal()">Annuler</button>
                </div>
            </form>
        </div>
    </div>
    
    <script>
        function openModal(id, login) {
            document.getElementById('modal_user_id').value = id;
            document.getElementById('modal_user_login').textContent = login;
            document.getElementById('mdpModal').classList.add('show');
        }
        
        function closeModal() {
            document.getElementById('mdpModal').classList.remove('show');
        }
        
        // Fermer la modal en cliquant à l'extérieur
        document.getElementById('mdpModal').addEventListener('click', function(e) {
            if (e.target === this) closeModal();
        });
    </script>
</body>
</html>
