<?php
ini_set('display_errors', 0);
error_reporting(E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

function jsonError($message, $code = 500, $debug = null) {
    http_response_code($code);
    $response = array('success' => false, 'error' => $message);
    if ($debug) {
        $response['debug'] = $debug;
    }
    die(json_encode($response, JSON_UNESCAPED_UNICODE));
}

define('DB_HOST', 'oz9643-001.eu.clouddb.ovh.net');
define('DB_PORT', '35297');
define('DB_USER', 'user_recreatoon');
define('DB_PASS', 'MathelodIMG59');
define('DB_NAME', 'recreatoon_DDB');

try {
    $dsn = "pgsql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME;
    $options = array(
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    );
    $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
} catch (PDOException $e) {
    jsonError('Erreur connexion DB: ' . $e->getMessage());
}

$method = $_SERVER['REQUEST_METHOD'];
$action = isset($_GET['action']) ? $_GET['action'] : 'list';
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'all';

$input = null;
if ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    if ($input && isset($input['action'])) {
        $action = $input['action'];
    }
}

switch ($action) {
    case 'update_status':
        updateStatus($pdo, $input);
        break;
    case 'get_order':
        $orderId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
        getOrderDetails($pdo, $orderId);
        break;
    case 'check_tables':
        checkTables($pdo);
        break;
    default:
        listOrders($pdo, $filter);
}

function checkTables($pdo) {
    try {
        $sql = "SELECT table_name FROM information_schema.tables WHERE table_schema = 'public' AND table_name IN ('commande', 'cmdeproduit', 'client_affiche')";
        $tables = $pdo->query($sql)->fetchAll(PDO::FETCH_COLUMN);
        
        $commandeCols = array();
        $produitCols = array();
        $clientCols = array();
        
        if (in_array('commande', $tables)) {
            $commandeCols = $pdo->query("SELECT column_name FROM information_schema.columns WHERE table_name = 'commande'")->fetchAll(PDO::FETCH_COLUMN);
        }
        
        if (in_array('cmdeproduit', $tables)) {
            $produitCols = $pdo->query("SELECT column_name FROM information_schema.columns WHERE table_name = 'cmdeproduit'")->fetchAll(PDO::FETCH_COLUMN);
        }
        
        if (in_array('client_affiche', $tables)) {
            $clientCols = $pdo->query("SELECT column_name FROM information_schema.columns WHERE table_name = 'client_affiche'")->fetchAll(PDO::FETCH_COLUMN);
        }
        
        $result = array(
            'success' => true,
            'tables' => $tables,
            'commande_columns' => $commandeCols,
            'cmdeproduit_columns' => $produitCols,
            'client_affiche_columns' => $clientCols
        );
        
        echo json_encode($result, JSON_UNESCAPED_UNICODE);
        
    } catch (Exception $e) {
        jsonError($e->getMessage());
    }
}

function getClientColumns($pdo) {
    $sql = "SELECT column_name FROM information_schema.columns WHERE table_name = 'client_affiche'";
    $cols = $pdo->query($sql)->fetchAll(PDO::FETCH_COLUMN);
    return $cols;
}

function listOrders($pdo, $filter) {
    try {
        // Vérifier si la table client_affiche existe
        $clientCols = array();
        $hasClientTable = false;
        
        try {
            $clientCols = getClientColumns($pdo);
            $hasClientTable = count($clientCols) > 0;
        } catch (Exception $e) {
            $hasClientTable = false;
        }
        
        // Construire les parties SELECT pour le client
        $clientSelectParts = array();
        
        if ($hasClientTable) {
            if (in_array('id', $clientCols)) {
                $clientSelectParts[] = "cl.id as client_id";
            }
            if (in_array('nom', $clientCols)) {
                $clientSelectParts[] = "cl.nom as client_nom";
            }
            if (in_array('prenom', $clientCols)) {
                $clientSelectParts[] = "cl.prenom as client_prenom";
            }
            if (in_array('email', $clientCols)) {
                $clientSelectParts[] = "cl.email as client_email";
            }
            if (in_array('telephone', $clientCols)) {
                $clientSelectParts[] = "cl.telephone as client_telephone";
            }
            if (in_array('adresse', $clientCols)) {
                $clientSelectParts[] = "cl.adresse as client_adresse";
            }
            if (in_array('code_postal', $clientCols)) {
                $clientSelectParts[] = "cl.code_postal as client_code_postal";
            }
            if (in_array('ville', $clientCols)) {
                $clientSelectParts[] = "cl.ville as client_ville";
            }
            if (in_array('pays', $clientCols)) {
                $clientSelectParts[] = "cl.pays as client_pays";
            }
        }
        
        $clientSelect = "";
        $clientJoin = "";
        
        if (count($clientSelectParts) > 0) {
            $clientSelect = ", " . implode(", ", $clientSelectParts);
            $clientJoin = "LEFT JOIN client_affiche cl ON c.user_id = cl.id";
        }
        
        $sql = "SELECT 
                    c.id as commande_id,
                    c.payment_id,
                    c.user_id,
                    c.user_email,
                    c.user_authenticated,
                    c.payment_method,
                    c.payment_status,
                    c.order_type,
                    c.total_items,
                    c.total_quantity,
                    c.total_price,
                    c.created_at,
                    c.updated_at,
                    COALESCE(c.statut, 'pdf') as statut,
                    c.date_expedition
                    " . $clientSelect . ",
                    p.id as produit_id,
                    p.item_id,
                    p.style,
                    p.format,
                    p.quantity as produit_quantity,
                    p.delivery,
                    p.price as item_price,
                    p.image_url,
                    p.chemin_vignette,
                    p.chemin_pdf
                FROM commande c
                " . $clientJoin . "
                LEFT JOIN cmdeproduit p ON c.id = p.commande_id
                ORDER BY c.created_at DESC, p.id ASC";
        
        $stmt = $pdo->query($sql);
        $rows = $stmt->fetchAll();
        
        // Regrouper par commande
        $commandes = array();
        
        foreach ($rows as $row) {
            $cmdId = $row['commande_id'];
            
            if (!isset($commandes[$cmdId])) {
                // Construire le nom complet du client
                $clientPrenom = isset($row['client_prenom']) ? $row['client_prenom'] : '';
                $clientNomFamille = isset($row['client_nom']) ? $row['client_nom'] : '';
                $clientNomComplet = trim($clientPrenom . ' ' . $clientNomFamille);
                
                if (empty($clientNomComplet)) {
                    $clientNomComplet = isset($row['user_email']) ? $row['user_email'] : 'Client inconnu';
                }
                
                // Créer l'objet client
                $client = array(
                    'id' => isset($row['client_id']) ? (int)$row['client_id'] : null,
                    'nom' => isset($row['client_nom']) ? $row['client_nom'] : null,
                    'prenom' => isset($row['client_prenom']) ? $row['client_prenom'] : null,
                    'nom_complet' => $clientNomComplet,
                    'email' => isset($row['client_email']) ? $row['client_email'] : $row['user_email'],
                    'telephone' => isset($row['client_telephone']) ? $row['client_telephone'] : null,
                    'adresse' => isset($row['client_adresse']) ? $row['client_adresse'] : null,
                    'code_postal' => isset($row['client_code_postal']) ? $row['client_code_postal'] : null,
                    'ville' => isset($row['client_ville']) ? $row['client_ville'] : null,
                    'pays' => isset($row['client_pays']) ? $row['client_pays'] : null
                );
                
                // Créer l'objet commande
                $commandes[$cmdId] = array(
                    'id' => (int)$row['commande_id'],
                    'payment_id' => $row['payment_id'],
                    'user_id' => isset($row['user_id']) ? (int)$row['user_id'] : 0,
                    'user_email' => $row['user_email'],
                    'user_authenticated' => isset($row['user_authenticated']) ? (bool)$row['user_authenticated'] : false,
                    'payment_method' => $row['payment_method'],
                    'payment_status' => $row['payment_status'],
                    'order_type' => $row['order_type'],
                    'total_items' => isset($row['total_items']) ? (int)$row['total_items'] : 0,
                    'total_quantity' => isset($row['total_quantity']) ? (int)$row['total_quantity'] : 0,
                    'total_price' => isset($row['total_price']) ? (float)$row['total_price'] : 0,
                    'created_at' => $row['created_at'],
                    'updated_at' => $row['updated_at'],
                    'statut' => $row['statut'] ? $row['statut'] : 'pdf',
                    'date_expedition' => $row['date_expedition'],
                    'client' => $client,
                    'produits' => array()
                );
            }
            
            // Ajouter le produit s'il existe
            if (isset($row['produit_id']) && $row['produit_id']) {
                $produit = array(
                    'id' => (int)$row['produit_id'],
                    'item_id' => $row['item_id'],
                    'style' => $row['style'],
                    'format' => $row['format'],
                    'quantity' => isset($row['produit_quantity']) ? (int)$row['produit_quantity'] : 1,
                    'delivery' => $row['delivery'],
                    'price' => isset($row['item_price']) ? (float)$row['item_price'] : 0,
                    'image_url' => $row['image_url'],
                    'chemin_vignette' => isset($row['chemin_vignette']) ? $row['chemin_vignette'] : null,
                    'chemin_pdf' => isset($row['chemin_pdf']) ? $row['chemin_pdf'] : null
                );
                $commandes[$cmdId]['produits'][] = $produit;
            }
        }
        
        // Convertir en tableau indexé
        $result = array_values($commandes);
        
        // Filtrer par statut si nécessaire
        if ($filter !== 'all') {
            $filtered = array();
            foreach ($result as $cmd) {
                $cmdStatut = isset($cmd['statut']) ? strtolower($cmd['statut']) : 'pdf';
                if ($cmdStatut === strtolower($filter)) {
                    $filtered[] = $cmd;
                }
            }
            $result = $filtered;
        }
        
        // Calculer les stats - AJOUT DE 'impression'
        $allCommandes = array_values($commandes);
        $stats = array(
            'total' => 0,
            'pdf' => 0,
            'envoyer' => 0,
            'impression' => 0,  // AJOUTÉ
            'attente' => 0,
            'expedie' => 0,
            'annuler' => 0,
            'archive' => 0
        );
        
        foreach ($allCommandes as $c) {
            $s = isset($c['statut']) ? strtolower($c['statut']) : 'pdf';
            if ($s === 'pdf' || $s === '') {
                $stats['pdf']++;
                $stats['total']++;
            } elseif ($s === 'envoyer') {
                $stats['envoyer']++;
                $stats['total']++;
            } elseif ($s === 'impression') {  // AJOUTÉ
                $stats['impression']++;
                $stats['total']++;
            } elseif ($s === 'attente') {
                $stats['attente']++;
                $stats['total']++;
            } elseif ($s === 'expedie') {
                $stats['expedie']++;
                $stats['total']++;
            } elseif ($s === 'annuler') {
                $stats['annuler']++;
                $stats['total']++;
            } elseif ($s === 'archive') {
                $stats['archive']++;
            }
        }
        
        $output = array(
            'success' => true,
            'commandes' => $result,
            'count' => count($result),
            'filter' => $filter,
            'stats' => $stats
        );
        
        echo json_encode($output, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        
    } catch (Exception $e) {
        $debug = array(
            'file' => $e->getFile(),
            'line' => $e->getLine()
        );
        jsonError('Erreur SQL: ' . $e->getMessage(), 500, $debug);
    }
}

function getOrderDetails($pdo, $id) {
    if (!$id) {
        jsonError('ID manquant', 400);
    }
    
    try {
        $clientCols = array();
        try {
            $clientCols = getClientColumns($pdo);
        } catch (Exception $e) {
            // Ignorer
        }
        
        $clientSelect = "";
        $clientJoin = "";
        
        if (count($clientCols) > 0) {
            $selectParts = array();
            
            if (in_array('nom', $clientCols)) {
                $selectParts[] = "cl.nom as client_nom";
            }
            if (in_array('prenom', $clientCols)) {
                $selectParts[] = "cl.prenom as client_prenom";
            }
            if (in_array('email', $clientCols)) {
                $selectParts[] = "cl.email as client_email";
            }
            if (in_array('telephone', $clientCols)) {
                $selectParts[] = "cl.telephone as client_telephone";
            }
            if (in_array('adresse', $clientCols)) {
                $selectParts[] = "cl.adresse as client_adresse";
            }
            if (in_array('code_postal', $clientCols)) {
                $selectParts[] = "cl.code_postal as client_code_postal";
            }
            if (in_array('ville', $clientCols)) {
                $selectParts[] = "cl.ville as client_ville";
            }
            if (in_array('pays', $clientCols)) {
                $selectParts[] = "cl.pays as client_pays";
            }
            
            if (count($selectParts) > 0) {
                $clientSelect = ", " . implode(", ", $selectParts);
                $clientJoin = "LEFT JOIN client_affiche cl ON c.user_id = cl.id";
            }
        }
        
        $sql = "SELECT c.* " . $clientSelect . " FROM commande c " . $clientJoin . " WHERE c.id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute(array($id));
        $commande = $stmt->fetch();
        
        if (!$commande) {
            jsonError('Commande non trouvée', 404);
        }
        
        $stmt = $pdo->prepare("SELECT * FROM cmdeproduit WHERE commande_id = ? ORDER BY id");
        $stmt->execute(array($id));
        $produits = $stmt->fetchAll();
        
        $output = array(
            'success' => true,
            'commande' => $commande,
            'produits' => $produits
        );
        
        echo json_encode($output, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        
    } catch (Exception $e) {
        jsonError($e->getMessage());
    }
}

function updateStatus($pdo, $input) {
    if (!isset($input['id']) || !isset($input['statut'])) {
        jsonError('ID ou statut manquant', 400);
    }
    
    $id = (int)$input['id'];
    $newStatus = strtolower($input['statut']);
    
    // AJOUT DE 'impression' DANS LES STATUTS AUTORISÉS
    $allowedStatuses = array('pdf', 'envoyer', 'impression', 'attente', 'expedie', 'annuler', 'archive');
    
    if (!in_array($newStatus, $allowedStatuses)) {
        jsonError('Statut invalide: ' . $newStatus, 400);
    }
    
    try {
        $check = $pdo->prepare("SELECT id, statut FROM commande WHERE id = ?");
        $check->execute(array($id));
        $commande = $check->fetch();
        
        if (!$commande) {
            jsonError('Commande non trouvée', 404);
        }
        
        $now = date('Y-m-d H:i:s');
        $dateExpedition = null;
        
        if ($newStatus === 'expedie') {
            $dateExpedition = $now;
            $update = $pdo->prepare("UPDATE commande SET statut = ?, updated_at = ?, date_expedition = ? WHERE id = ?");
            $update->execute(array($newStatus, $now, $dateExpedition, $id));
        } else {
            $update = $pdo->prepare("UPDATE commande SET statut = ?, updated_at = ? WHERE id = ?");
            $update->execute(array($newStatus, $now, $id));
        }
        
        $output = array(
            'success' => true,
            'message' => 'Statut mis à jour',
            'order_id' => $id,
            'new_status' => $newStatus,
            'date_expedition' => $dateExpedition,
            'updated_at' => $now
        );
        
        echo json_encode($output, JSON_UNESCAPED_UNICODE);
        
    } catch (Exception $e) {
        jsonError($e->getMessage());
    }
}
?>